# -*- coding: UTF-8 -*-
import re,os

divide = "*********^^^^^^^^^^************^^^^^^^^^^*********" 
style = "python"
fail_flag = "TOOLKIT_EXE_CMD_FAILED"
sendfail_flag = "TOOLKIT_SEND_CMD_TIME_OUT"
#返回所有回文时用于回文行之间连接的标识
LINE_SPLIT_SIGN = '\\n'
 

# **************************************
# 函数名称: getCommandRetFromTxt
# 功能说明: 从文件中获取命令的回文
# 输入参数: filePath：文件的路径
#         command：命令
# 输出参数: 命令回文信息
# **************************************
def getCommandRetFromTxt(context):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    flag = False
    
    command = context.get("command")
    commandList = command.split(',')
    filePath = context.get("path")
    fileHandle = open(filePath, 'r')
    for i in range(len(commandList)):
        for line in fileHandle:
            if commandList[i].strip().lower() in line.strip().lower():
                flag = True
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    break
                else:
                    cmdRetList.append(line.strip())
            
    fileHandle.close()  
    retList = cmdRetList[1:len(cmdRetList)] 
    return retList


# **************************************
# 函数名称: getSameCommandsRetFromTxt
# 功能说明: 从回文文件中获取有规律的几条命令的回文,比如:
# cmd_display_hba_card_esxcli_megaraid_sas
# cmd_display_hba_card_esxcli_ata_piix
# 这种情况在模板中配置:cmd_display_hba_card_esxcli_
# 即可获取文件中所有命令中包含:cmd_display_hba_card_esxcli_的回文信息
# 输入参数: filePath：文件的路径
#         command：命令
# 输出参数: 命令回文信息
# **************************************
def getSameCommandsRetFromTxt(context):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    flag = False
    
    command = context.get("command")
    commandList = command.split(',')
    filePath = context.get("path")
    
    fileHandle = open(filePath, 'r')
    for i in range(len(commandList)):
        for line in fileHandle:
            if commandList[i].strip().lower() in line.strip().lower():
                flag = True
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append("---------***************-----------")
                else:
                    cmdRetList.append(line.strip())
            
    fileHandle.close()  
    retList = cmdRetList[0:len(cmdRetList)-2]    
    return retList 


# **************************************
# 函数名称: getCommandRetFromTxt
# 功能说明: 从文件中获取命令的回文,并且命令带有参数
# 输入参数: filePath：文件的路径
#         command：命令(带有参数)
# 输出参数: 命令回文信息
# **************************************
def getCommandRetFromTxtWithPara(context, command):
    '''
    @summary: 从mml文件中获取包含关键的回显信息
    @param filePath: 文件路径
    @param keyword: 关键字
    @return: MML回显组成的列表
    '''
    cmdRetList = []
    flag = False
    
    filePath = context.get("path")
    
    fileHandle = open(filePath, 'r')

    for line in fileHandle:
        if command.strip().lower() in line.strip().lower():
            flag = True
            continue
        if True == flag:
            if divide.strip().lower() in line.strip().lower():
                flag = False
                break
            else:
                cmdRetList.append(line.strip())
            
    fileHandle.close()  
    retList = cmdRetList[1:len(cmdRetList)]    
    return retList   

# **************************************
# 函数名称: getCommandRet
# 功能说明: 获取单条命令的回文，包括CLI命令和sql的命令
# 输入参数: CLI：cli命令
#         LANGUAGE：环境语言信息
# 输出参数: display:回文信息
# **************************************
def getSingleCommandRet(context, cmd_info_id, command):
    fun_err_msg = ''

    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    display = context.get("ret_map")
    
    cmd_display_temp = CLI.execCmdNoLogTimout(command,60)
    if cmd_info_id.startswith ('cmd_info'):     
        display.put("cmd_display"+cmd_info_id[8:], cmd_display_temp)
    else:
        sql_display.put("sql_display"+cmd_info_id[8:], sql_display_temp)
        
    if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en"==LANGUAGE:
            fun_err_msg        += command + ":\texecute failed\r\n"
        else:
            fun_err_msg        += command + u":\t执行失败\r\n"
    else:
        if "en"==LANGUAGE:
            fun_err_msg        += command + ":\texecute success\r\n"
        else:
            fun_err_msg        += command + u":\t执行成功\r\n"
            
    display.put("err_msg", fun_err_msg)

    return display

# **************************************
# 函数名称: getCommandRet
# 功能说明: 获取CLI命令的回文
# 输入参数: context：上下文信息
#         cmd_info_id：命令描述信息
#         cmd_info_desc：具体CLI命令信息
# 输出参数: cmd_display:回文信息
# **************************************
def getCommandRet(context, cmd_info_id, cmd_info_desc):
    fun_err_msg = ''

    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    
    for rg in range(len(cmd_info_id)):
        cmd_display_temp = CLI.execCmdNoLogTimout(cmd_info_desc[rg],60)  
        cmd_display.put("cmd_display"+(cmd_info_id[rg])[8:], cmd_display_temp)
            
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=cmd_info_desc[rg] + ":\texecute success\r\n"
            else:
                fun_err_msg        +=cmd_info_desc[rg] + u":\t执行成功\r\n"
    cmd_display.put("err_msg", fun_err_msg)

    return cmd_display

# **************************************
# 函数名称: getSqlRet
# 功能说明: 获取SQL命令的回文
# 输入参数: context：上下文信息
#         
# 输出参数: sql_display:回文信息
# **************************************
def getSqlRet(context, sql_info):
    fun_err_msg = ''
    
    CLI = context.get("DBConn")
    LANGUAGE = context.get("lang")
    sql_display = context.get("ret_map")
    
    for item in sql_info:
        sql_display_temp = CLI.execSql(sql_info.get(item))
        sql_display.put("sql_display"+(item)[8:], sql_display_temp)
        if None == sql_display_temp.getSqlResult() or '' == sql_display_temp.getSqlResult() or 'TOOLKIT_SEND_SQL_TIME_OUT' == sql_display_temp.getSqlResult():
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute failed\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行失败\r\n"
        else:
            if "en"==LANGUAGE:
                fun_err_msg        +=sql_info.get(item) + ":\texecute success\r\n"
            else:
                fun_err_msg        +=sql_info.get(item) + u":\t执行成功\r\n"
    sql_display.put("err_msg", fun_err_msg)

    return sql_display

# **************************************
# 函数名称: parseRetWithSep
# 功能说明: 解析
# 输入参数: retList：回文信息
#        keyWord：关键字信息
#        defaultSep：分隔符
# 输出参数: 无
# 返回值   : 关键字对应的值
# 例如：  解析 “ketword = value”结构，并且返回value。例如
#      Driver Version = @(#) fcd B.11.31.1209.01 Sep  4 2012
#      返回@(#) fcd B.11.31.1209.01 Sep  4 2012
# **************************************
def parseRetWithSep(retList, keyWord, defaultSep="="):
    value = ""
    try:
        for i in range(0,len(retList)):
            if keyWord in retList[i] or keyWord.lower() in retList[i].lower():
                value = re.split(defaultSep, retList[i])[1].strip()
                break
    except:
        return ""
        
    return value

def getValueStrFromRetWithSep(retList, keyWord, defaultSep="="):
    value = ""
    valueList = []
    try:
        for i in range(0,len(retList)):
            if keyWord in retList[i] or keyWord in retList[i].lower():
                value = re.split(defaultSep, retList[i])[1].strip()
                valueList.append(value)
    except:
        return ""
    valueList = sorted(set(valueList),key=valueList.index)  

    return ";".join(valueList)

# **************************************
# 函数名称: isBelongToList
# 功能说明: 判断字符串是否为列表中每个元素的一部分
# 输入参数: hbaTypeList：列表字符串
#         type ：字符串
# 输出参数: 无
# 返回值 ： True/False
# **************************************
def isBelongToList(hbaTypeList, type):
    for i in range(0,len(hbaTypeList)):
        if type in hbaTypeList[i]:
            return True
    
    return False

# **************************************
# 函数名称: getLinesFromRetWithKeyword
# 功能说明: 获取含有关键字的哪一行
# 输入参数: tempList：列表字符串
#         keyWordList ：查询的关键字字符串list
# 输出参数: 无
# 返回值 ： retList
# **************************************
def getLinesFromRetWithKeyword(tempList, keyWordList):
    retList = []
    for i in range(0, len(tempList)):
        for j in range (0, len(keyWordList)):
            if keyWordList[j] in tempList[i]:
                retList.append(tempList[i])
    
    return retList


def addValueToMap(dmap,style,key,value):
    if 'python' == style:
        dmap[key]=value
    if 'jython' == style:
        dmap.setdefault(key,value)
        
def getValueFMap(dmap,style,key):
    if 'python' == style:
        return dmap[key]
    if 'jython' == style:
        return dmap.get(key)


#数据迁移    
#拼json数组result 
def get_jsonstr(json_arr_key,attribute_arr, value_lst):
    result = ""
    result = "{" + "\""+json_arr_key +"\""+ ':[{'
    count = len(value_lst) / len(attribute_arr) if len(attribute_arr) != 0 else len(value_lst)
    match = False
    len_attr = len(attribute_arr)
    len_value = len(value_lst)
    if (0==len_value%len_attr) and 0!=len_value:
        match = True
        for i in range(count):
            for j in range(len_attr):
                result = result + "\""+attribute_arr[j]+ "\"" + ':' + "\""+ value_lst[len_attr*i+j]+ "\"" + ','
            result = result[0:-1] + '},{'
        result = result[0:-2]
        result = result + ']}'
    else:
        pass
    
    if match:
        return result
    #check result
    if not match:
        result =""
        result = "{" + "'"+json_arr_key +"'"+ ':[{'
        for j in range(len(attribute_arr)):
            result = result + "'"+attribute_arr[j]+ "'" + ':' + "'"+"NA"+ "'" + ','
        result = result[0:-1] + '},{'
        result = result[0:-2]
        result = result + ']}'
        return result
    else:
        pass
        
#command is "key:server_info; Server_moder:cmd_display_xxx,cmd_display_yyy;CPU_model:cmd_display_mmm"
#attrcom_dic is {} #属性名:[命令1,命令2...]
#context：出入的参数
#return:attrcom_dic
def get_attrcom_dic(context):
    command = getValueFMap(context,style,'command')
    #去除最后面的';'
    if ';' == command.strip()[-1]:
        command = command[0:-1]
    attrcom_dic= {}
    try:
        for comd in command.split(';'):
            lst = comd.split(':')
            key = lst[0].strip()
        
            if (1 < len(lst))and (',' in lst[1]):
                addValueToMap(attrcom_dic, style, key, lst[1].strip().split(','))
            else:
                addValueToMap(attrcom_dic, style, key, [lst[1].strip()])
    except:
        return attrcom_dic
    return attrcom_dic


#获取属性列表字典中所有命令组成的列表
def get_purecommands_lst(attrcom_dic):
    all_comds_lst = []
    keyvalue = getValueFMap(attrcom_dic, style, 'key')[0].strip()
    for key in attrcom_dic.keys():
        value = getValueFMap(attrcom_dic, style, key)
        for i in range(len(value)):
            all_comds_lst.append(value[i])
    all_comds_lst.remove(keyvalue)
    return all_comds_lst

#根据命令出现在txt报告中的先后顺序对命令列表进行排序减少读文件的次数
#attrcom_dic is {'Server_moder': ['cmd_xxx', 'cmd_yyy'], 'CPU_model': ['cmd_mmm', 'cmd_nnn'], 'key': 'Server_Info'}
#comds:传入的所有命令
#path:txt报告路径
def get_comdslst_byfile(comds,path):
    all_comds_byfile = []
    file_handler = open(path,'r')
    comds = ';'.join(comds)
    for line in file_handler:
        if line.strip().lower() in comds.lower():
            if ""!=line.strip() and ("display" in line.lower()):
                all_comds_byfile.append(line.strip())
        else:
            continue
    file_handler.close()
    return all_comds_byfile

def get_similarcomds_byfile(comds,path):
    all_comds_byfile = []
    file_handler = open(path,'r')
    for line in file_handler:
        if comds[0].lower() in line.strip():
            all_comds_byfile.append(line.strip())
        else:
            continue
    file_handler.close()
    return all_comds_byfile



#{属性名：[对应回文组成的列表]}
#all_filecomds:根据报告排好序的命令列表
def get_attrlst_dic(attr_comds_dic,all_filecomds,path):
    flag =False
    # {属性名:对应列表}
    attrlst_dic = {}
    key_comds_lst = []
    templst = []
    cmdRetList = []
    for i in range(len(all_filecomds)):
        fileHandle = open(path, 'r')
        for line in fileHandle:
            if "" ==line.strip():
                continue
            if (all_filecomds[i].strip().lower() in line.strip().lower()) and ('display' in line.lower()):
                flag = True
                cmdRetList.append(line)
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append(divide)
                    break
                else:
                    cmdRetList.append(line.strip())
                    continue
        fileHandle.close()  
    templst = cmdRetList[0:len(cmdRetList)]
    for key in attr_comds_dic.keys():
        cmd_templst = []
        flag = False
        comds_lst = getValueFMap(attr_comds_dic, style, key)
        for comd in comds_lst:
            for line in templst:
                if comd.strip().lower() in line.lower():
                    flag =True
                    cmd_templst.append(line)
                    continue
                if True == flag:
                    if divide.strip().lower() in line.strip().lower():
                        flag =False
                        cmd_templst.append(line)
                        break
                    else:
                        cmd_templst.append(line.strip())
        addValueToMap(attrlst_dic, style, key, cmd_templst)
    return attrlst_dic


#{属性名：[对应回文组成的列表]} 相似的命令的回文，常见递归调用的时候，比如hp-ux之hba卡
#all_filecomds:根据报告排好序的命令列表
def get_attrsimilar_lst_dic(attr_comds_dic,all_filecomds,path):
    flag =False
    # {属性名:对应列表}
    attrlst_dic = {}
    key_comds_lst = []
    templst = []
    cmdRetList = []
    for i in range(len(all_filecomds)):
        fileHandle = open(path, 'r')
        for line in fileHandle:
            if "" ==line.strip():
                continue
            if (all_filecomds[i].strip().lower() in line.strip().lower()) and ('cmd_display' in line.lower()):
                flag = True
                cmdRetList.append(line)
                continue
            if True == flag:
                if divide.strip().lower() in line.strip().lower():
                    flag = False
                    cmdRetList.append(divide)
                    break
                else:
                    cmdRetList.append(line.strip())
                    continue
        fileHandle.close()  
    templst = cmdRetList[0:len(cmdRetList)]
    for key in attr_comds_dic.keys():
        cmd_templst = []
        comds_lst = getValueFMap(attr_comds_dic, style, key)
        all_comds_lst = []
        
        for comd in comds_lst:
            for line in templst:
                if comd.strip().lower() in line.lower():
                    all_comds_lst.append(line) 
        
        for comd in all_comds_lst:
            for line in templst:
                if comd in line:
                    flag =True
                    cmd_templst.append(line)
                    continue
                if True == flag:
                    if divide.strip().lower() in line.strip().lower():
                        flag =False
                        cmd_templst.append(line)
                        break
                    else:
                        cmd_templst.append(line.strip())
        addValueToMap(attrlst_dic, style, key, cmd_templst)
    return attrlst_dic


#获取json数组名字
def get_jsonarr_name(attrcom_dic):
    return getValueFMap(attrcom_dic,style,"key")[0].strip()

#过滤掉值是空的项
def checktempList(tempList):
    lst = []
    for line in tempList:
        if '' != line.strip():
            lst.append(line)
    return lst

#检查回文中是否有命令失败标志或者命令长度是否为0
#是则返回True，表示当前回文对应命令执行失败
def checkList_status(tempList):
    flag = False
    if 0 == len(tempList):
        flag = True
        return flag
    
    for line in tempList:
        if fail_flag in line:
            flag = True
            return flag
    return flag

#检查命令对应的回文是否成功，成功则返回True,否则False
def is_success(templst):
    if 0 == len(templst):
        return False
    for line in templst:
        if ((fail_flag.lower() in line.lower())or (sendfail_flag.lower() in line.lower())):
            return False
    return True

#判断字符串 是否包含于列表中的某项
def is_belong_lst(value,templst):
    result = False
    for line in templst:
        if value.lower().strip() in line.lower():
            result = True 
            break
    return result 


def has_cluster(cluster_block_lst):
    result = False 
    if 0 == len(cluster_block_lst):
        return result

    for lst in cluster_block_lst:
        temp = is_success(lst)
        #有一个回文成功，则有该集群
        if temp == True:
            result = True
            break
    return result


def get_valuelst_bydesc(block_lst,desc):
    lst = []
    for block in block_lst:
        temp = ';'.join(block)
        if desc.lower() in temp.lower():
            lst = block
            break
    return lst

def isBelongLst(pamstr,pamlst):
    result = False
    for line in pamlst:
        if pamstr.lower() in line.lower():
            result = True
            break
    return result
