﻿# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import re
import time
import base64
import traceback

CLI = None
LANGUAGE = None
IP_ADDR = None
EXE_CMD_FAILED = "TOOLKIT_EXE_CMD_FAILED"
SEND_CMD_TIME_OUT = "TOOLKIT_SEND_CMD_TIME_OUT"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    logger = context.get("Logger")
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    dev_type = ''
    sn = ''
    version = 'Not Found'

    name = check_and_get_result(get_device_name())
    if name:
        name = 'AIX'
        try:
            sn = check_and_get_result(get_serial_number(context))
            dev_type = check_and_get_result(get_dev_type())
            version = check_and_get_result(get_product_version())
            logger.info("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
        except:
            logger.error("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
            logger.error("the except info is:" + traceback.format_exc())

    else:
        name = 'Not Aix'
        dev_type = ""
        sn = ""
        version = ""

    return {"name": name, "type":dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """

    return str(result)


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmdWithTimout("oslevel", 60)

    sys_list = op_sys_info.splitlines()
    sys_type = sys_list[1].strip() if len(sys_list) == 3 else sys_list[
        -1].strip()

    dev_type = "AIX " + sys_type

    #有些时候 查询mac地址的命令会执行失败，导致无法获取到正确的型号
    if(EXE_CMD_FAILED in dev_type) or (SEND_CMD_TIME_OUT in dev_type):
        dev_type = "AIX " + op_sys_info.splitlines()[-2].strip()
        dev_type = dev_type.replace(EXE_CMD_FAILED, '')
        dev_type = dev_type.replace(SEND_CMD_TIME_OUT, '')

    if "AIX " != dev_type:
        fun_flag = CHECK_PASS
    return fun_flag, dev_type, fun_err_msg


# need to explain this function.

def fetch_ubuntu_base_info():
    cli_ret = CLI.execCmdWithTimout("cat /etc/issue", 60)
    cli_ret_list = cli_ret.splitlines()
    cli_ret_lists = cli_ret_list[1].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    device_name = ""
    cli_ret = CLI.execCmdWithTimout("uname -a", 60)
    for line in cli_ret.splitlines():
        if 'aix' in line.lower():
            device_name = line.split()[0]
            break
    logger.info("the device name is:" + device_name)

    # here
    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    cli_flag = CHECK_FAIL
    fun_err_msg = ''
    op_sys_ver = CLI.execCmdWithTimout("oslevel -s", 60)
    product_version = op_sys_ver.splitlines()[1].strip()
    if '' != product_version:
        fun_flag = CHECK_PASS
    return cli_flag, product_version, fun_err_msg



#need to explain this function.
def get_serial_number(context):
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str = ''
    en_num = CLI.execCmdWithTimout("netstat -in|grep " + IP_ADDR + " |awk '{print $1}'", 60)
    mac_address = CLI.execCmdWithTimout("netstat -in|grep " + en_num.splitlines()[1].strip() + "|grep link|awk '{print $4}'", 60)
    mac_arr = mac_address.splitlines()[1].strip().split('.')

    for mac in mac_arr:
        if(len(mac) == 1):
            mac_str = "0"
        else:
            mac_str += mac
    if "0" == mac_str:
        serial_number = "SN" + IP_ADDR
        context.get("dev").setSnFail(False)
    else:
        serial_number = mac_str + IP_ADDR
    if (EXE_CMD_FAILED in serial_number) or (SEND_CMD_TIME_OUT in serial_number):
        serial_number = 'SN' + getBase64Sn(IP_ADDR)
        context.get("dev").setSnFail(False)
        serial_number = serial_number.replace('.', '')
        serial_number = getBase64Sn(serial_number)
        return fun_flag, serial_number, fun_err_msg

    if '' != serial_number.strip():
        serial_number = "SN" + serial_number
        if LANGUAGE == "zh":
            fun_err_msg = u"获取设备版本失败。"
        else:
            fun_err_msg = "Get product version failed."
    else:
        serial_number = 'SN' + getBase64Sn(IP_ADDR)
        context.get("dev").setSnFail(False)

    serial_number = serial_number.replace('.', '')

    fun_flag = CHECK_PASS
    return fun_flag, serial_number, fun_err_msg



def getBase64Sn(serial_number):
    #sn查询失败则用ip地址base64加密后的值作为sn,以下是替换掉特殊字符
    serial_number = base64.encodestring(serial_number)
    serial_number = serial_number.replace('=', '')
    serial_number = serial_number.replace('\n', '')
    serial_number = serial_number.replace('+', '')
    serial_number = serial_number.replace('/', '')
    serial_number = serial_number.upper()
    #如果加密后密文太长则只取前面几位
    if len(serial_number) > 36:
        serial_number = serial_number[0:36]
    return serial_number








