# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import os
import sys
import re
import traceback
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
from util import log

CLI = None
IP_ADDR = None
ORACLE_LINUX = "Oracle Linux "
ORACLE_VM = "Oracle VM "


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    logger = context.get("Logger")
    global CLI
    CLI = context.get("SSH")
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    # is FusionSphere
    isFusionSphere = CLI.execCmdWithTimout("cat /opt/galax/version/GalaxVersion.cfg", 60)
    log.info(context, isFusionSphere)
    fusionSpherePattern = re.compile(r"V\d{3}R\d{3}C\d{2}RC\S{1,2}|V\d{3}R\d{3}C\d{2}SPC\S{3}|V\d{3}R\d{3}C\d{2}SPH\S{3}|V\d{3}R\d{3}C\d{2}CP\S{4}|V\d{3}R\d{3}C\d{2}HP\S{4}|V\d{3}R\d{3}C\d{2}")
    verGroups = fusionSpherePattern.findall(isFusionSphere)
    if verGroups:
        return {"name":"Not Linux", "type":"Not Found", "sn":"", "version":""}

    name = 'Not Linux'
    dev_type = ''
    sn = ''
    version = 'Not Found'
    name = get_device_name()
    if name:
        try:
            sn = get_serial_number()
            version = get_product_version()
            dev_type = get_dev_type()
            logger.info("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
        except:
            logger.error("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
            logger.error("the except info is:" + traceback.format_exc())

    return {"name": name, "type": dev_type, "sn": sn, "version": version}


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    dev_type = ''
    op_sys_info = CLI.execCmdWithTimout("cat /etc/*release", 60)

    if 'No such file or directory' not in op_sys_info:
        tem_line = op_sys_info.splitlines()[1:]
        if 'Asianux' in op_sys_info:
            for i in range(0, len(tem_line)):
                #####################     Suse Area    #####################
                if 'Asianux' in tem_line[i]:
                    dev_type = 'Asianux ' + tem_line[i].split()[2]
                    break
        elif 'Debian' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Debian' in tem_line[i]:
                    dev_type = 'Debian ' + tem_line[i].split()[2]
                    break
        elif ORACLE_LINUX in op_sys_info or ORACLE_VM in op_sys_info:
            dev_type = get_dev_type_release_oracle(tem_line)
        elif 'SUSE' in op_sys_info:
            version = "0"
            patchVersion = "0"
            for i in range(0, len(tem_line)):
                if tem_line[i].startswith("VERSION") and version == '0':
                    version = tem_line[i].split("=")[1].strip()
                if tem_line[i].startswith("PATCHLEVEL ="):
                    patchVersion = tem_line[i].split("=")[1].strip()
            if "0" == patchVersion:
                dev_type = 'SUSE %s' % (version.replace("\"", ""))
            else:
                dev_type = 'SUSE %s SP%s' % (version, patchVersion)
                #####################   Red Hat Area    #####################
        elif 'Red Hat' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Red Hat' in tem_line[i] and "=" not in tem_line[i]:
                    tempsectors = tem_line[i].split()
                    versionIndex = min(6, len(tempsectors) - 1)
                    dev_type = "Red Hat " + tempsectors[versionIndex]
                    break
        elif 'CentOS' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'CentOS' in tem_line[i]:
                    dev_type = "CentOS " + tem_line[i].split()[2]
                    if dev_type == 'CentOS release':
                        dev_type = "CentOS " + tem_line[i].split()[3]
                    break
        elif 'xenserver' in op_sys_info.lower():
            for i in range(0, len(tem_line)):
                if 'VERSION_ID=' in tem_line[i]:
                    dev_type = "XenServer " + re.split('VERSION_ID=', tem_line[i])[-1].replace(
                        "\"", "")
                    break
                #####################   Ubuntu Area    #####################
        elif 'Ubuntu' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Ubuntu' in tem_line[i]:
                    dev_type = fetch_ubuntu_base_info()
                    break

    if not dev_type:
        op_sys_info = CLI.execCmdWithTimout("cat /etc/issue", 60)
        tem_line = op_sys_info.splitlines()[1:]
        if 'Asianux' in op_sys_info:
            for i in range(0, len(tem_line)):
                #####################     Suse Area    #####################
                if 'Asianux' in tem_line[i]:
                    dev_type = 'Asianux ' + tem_line[i].split()[2]
                    break
        elif 'Debian' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Debian' in tem_line[i]:
                    dev_type = 'Debian ' + tem_line[i].split()[2]
                    break
        elif ORACLE_LINUX in op_sys_info or ORACLE_VM in op_sys_info:
            dev_type = get_dev_type_issue_oracle(tem_line)
        elif 'SUSE' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'SUSE' in tem_line[i]:
                    dev_type = "SUSE " + tem_line[i].split()[6] + " " + tem_line[i].split()[7]
                    break
                #####################   Red Hat Area    #####################
        elif 'Red Hat' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Red Hat' in tem_line[i]:
                    dev_type = "Red Hat " + tem_line[i].split()[6]
                    break
        elif 'CentOS' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'CentOS' in tem_line[i]:
                    dev_type = "CentOS " + tem_line[i].split()[2]
                    if dev_type == 'CentOS release':
                        dev_type = "CentOS " + tem_line[i].split()[3]
                    break
        elif 'XenServer' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'XenServer' in tem_line[i]:
                    dev_type = "XenServer " + re.split(' |-', tem_line[i])[2]
                    break
                #####################   Ubuntu Area    #####################
        elif 'Ubuntu' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Ubuntu' in tem_line[i]:
                    dev_type = fetch_ubuntu_base_info()
                    break

    if dev_type == '':
        dev_type = "Unknown"
    return dev_type


def get_dev_type_release_oracle(tem_line):
    """
    识别oracle linux、oracle vm的类型
    :param tem_line: 回文
    :return:设备类型
    """
    dev_type = ""
    for i in range(0, len(tem_line)):
        dev_type, dev_type_line = parse_line(tem_line[i])
        if dev_type_line:
            info_arrays = dev_type_line.split()
            match_version = re.findall(r'\d+.\d+', dev_type_line, re.I)
            version = info_arrays[-1] if len(match_version) < 1 else match_version[0]
            version = info_arrays[4] if len(info_arrays) > 4 else version
            dev_type = dev_type + version
            break
    return dev_type


def get_dev_type_issue_oracle(tem_line):
    """
    识别oracle linux、oracle vm的类型
    :param tem_line: 回文
    :return:设备类型
    """
    dev_type = ""
    for i in range(0, len(tem_line)):
        dev_type, dev_type_line = parse_line(tem_line[i])
        if dev_type_line:
            dev_type = dev_type + dev_type_line.split()[4]
            break
    return dev_type


def parse_line(line):
    """
    解析数据行（识别是否是Oracle Linux/VM，并返回改行数据）
    :param line: 回文
    :return:具体类型和行数据
    """
    if ORACLE_LINUX in line:
        return ORACLE_LINUX, line
    if ORACLE_VM in line:
        return ORACLE_VM, line
    return "", ""


# need to explain this function.
def fetch_ubuntu_base_info():
    cli_ret = CLI.execCmdWithTimout("cat /etc/issue", 60)
    cli_ret_list = cli_ret.splitlines()
    cli_ret_lists = cli_ret_list[1].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    device_name = ''
    cli_ret = CLI.execCmdWithTimout("uname -a", 60)
    for line in cli_ret.splitlines():
        if line.lower().startswith("linux"):
            device_name = "Linux"
            break
    logger.info("the device name is:" + device_name)
    return device_name


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    product_version = ''
    op_sys_ver = CLI.execCmdWithTimout("cat /proc/version", 60)
    for line in op_sys_ver.splitlines():
        if "linux" in line.lower():
            product_version = re.split(' |-', line)[2].strip()
    return product_version


# need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    serial_number = ''
    mac_str = ""
    mac_address = ''
    if_config_str = CLI.execCmdWithTimout("/sbin/ifconfig", 60)
    ip_link_show = CLI.execCmdWithTimout("/sbin/ip link show", 60)

    if "no such file or directory" in if_config_str.lower():
        if_config_str = CLI.execCmdWithTimout("ifconfig", 60)

    if ip_link_show.find("TOOLKIT_EXE_CMD_FAILED") > 0:
        ip_link_show = CLI.execCmdWithTimout("ip link show", 60)

    temp_list = if_config_str.splitlines()
    temp_list_2 = ip_link_show.splitlines()

    for i in range(0, len(temp_list)):
        if IP_ADDR in temp_list[i]:
            eth_name = temp_list[i - 1].split()[0]
            if eth_name.find(":") >= 0:
                eth_name = eth_name.split(':')[0]

            eth_name = eth_name.split(':')[0]
            for j in range(0, len(temp_list_2)):
                if eth_name in temp_list_2[j]:
                    mac_address = temp_list_2[j + 1].split()[1]
                    break
            mac_arr = mac_address.strip().split(':')

            for mac in mac_arr:
                if(len(mac) == 1):
                    mac_str = "0"
                else:
                    mac_str += mac
            if "0" == mac_str:
                serial_number = IP_ADDR
            else:
                serial_number = mac_str.upper() + IP_ADDR
            break
    if '' == serial_number:
        serial_number = "SN" + IP_ADDR
    serial_number = serial_number.replace('.', '').replace(':', '')
    return serial_number


def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S', time.localtime(time.time()))
    t = t.replace('-', '')
    return t

