# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

import os
import sys
reload(sys)
sys.setdefaultencoding('utf-8')

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
from util import get_cmd_ret
from util import get_ip_addr


def execute(context):
    """
    添加主机获取信息
    :param context: context
    :return: cliRet
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    global ip_addr
    logger = context.get("Logger")
    ip_addr = get_ip_addr(context)

    dev_type = ''
    sn = ''
    version = 'Not Found'
    name = get_device_name(context)
    if name:
        sn = ip_addr
        dev_type = get_dev_type(context)
        version = get_product_version(context)
        logger.info("the device name is: %s, the type is : %s, the sn is : %s,"
                    " the version is : %s" % (name, dev_type, sn, version))
    else:
        name = "Not Aix"
        dev_type = ""
        sn = ""
        version = ""
    return {"name": name, "type": dev_type, "sn": sn, "version": version, "ip": ip_addr}


def get_dev_type(context):
    """
    获取操作系统类型
    :param context: context
    :return:  操作系统类型
    """
    dev_type = ""
    context["command"] = "oslevel"
    op_sys_info = get_cmd_ret(context)
    dev_type = "AIX " + op_sys_info[-1].strip()
    return dev_type


def get_device_name(context):
    """
    获取device_name
    :param context: context
    :return: device_name
    """
    context["command"] = "uname -a"
    device_name_info = get_cmd_ret(context)
    logger.info("the device name is:" + "".join(device_name_info))
    device_name = ''
    for line in device_name_info:
        if line.lower().startswith("aix"):
            device_name = "AIX"
            break
    logger.info("the device name is:" + device_name)
    return device_name


def get_product_version(context):
    """
    获取操作系统版本号
    :return:  操作系统版本号
    """
    context["command"] = "oslevel -s"
    op_sys_ver = get_cmd_ret(context)
    product_version = op_sys_ver[-1].strip()
    return product_version
