# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

import os
import sys
import re
reload(sys)
sys.setdefaultencoding('utf-8')

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
from util import get_cmd_ret
from util import get_ip_addr

def execute(context):
    """
    添加主机获取信息
    :param context: context
    :return: cliRet
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    global ip_addr
    logger = context.get("Logger")
    ip_addr = get_ip_addr(context)

    dev_type = ""
    sn = ""
    version = ""
    name = get_device_name(context)
    if name:
        sn = ip_addr
        dev_type = get_dev_type(context)
        version = get_product_version(context)
        logger.info("the device name is: %s, the type is : %s, the sn is : %s,"
                    " the version is : %s" % (name, dev_type, sn, version))
    else:
        name = "Not Aix"
    return {"name": name, "type": dev_type, "sn": sn, "version": version, "ip": ip_addr}


def get_dev_type(context):
    """
    获取操作系统类型
    :param context: 上下文
    :return:  操作系统类型
    """
    dev_type = ""
    context["command"] = "machinfo|egrep 'Release|release  '"
    op_sys_info = get_cmd_ret(context)
    if op_sys_info:
        dev_type = re.split(':|=', op_sys_info[0])[1].strip()
    if not dev_type:
        dev_type = get_dev_type_byuname(context)
    return dev_type


def get_dev_type_byuname(context):
    """
    通过uname -a获取type
    :param context: 上下文
    :return: type
    """
    type = ''
    context["command"] = "uname -a"
    op_sys_info = get_cmd_ret(context)
    if not op_sys_info:
        return type
    for line in op_sys_info:
        if 'b.11' in line.lower():
            lst = line.split()
            if len(lst) > 2:
                return lst[2]
    return type


def get_device_name(context):
    """
    获取device_name
    :param context: context
    :return: device_name
    """
    context["command"] = "uname -a"
    device_name_info = get_cmd_ret(context)
    device_name = ''
    for line in device_name_info:
        if line.lower().startswith("hp-ux"):
            device_name = "HP-UX"
            break
    logger.info("the device name is:" + device_name)
    return device_name


def get_product_version(context):
    """
    获取操作系统版本号
    :return:  操作系统版本号
    """
    context["command"] = "machinfo|egrep 'Version|version  '"
    op_sys_ver = get_cmd_ret(context)
    product_version = ""
    if op_sys_ver:
        product_version = re.split(':|=', op_sys_ver[0])[-1].strip()
    return product_version
