# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

import os
import sys
import re
reload(sys)
sys.setdefaultencoding('utf-8')

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
from util import get_cmd_ret
from util import get_ip_addr

def execute(context):
    """
    添加主机获取信息
    :param context: 上下文
    :return: 主机信息
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    global ip_addr
    logger = context.get("Logger")
    ip_addr = get_ip_addr(context)

    # is FusionSphere
    context["command"] = "cat /opt/galax/version/GalaxVersion.cfg"
    is_fusion_sphere = get_cmd_ret(context)
    fusion_sphere_pattern = re.compile(
        r"V\d{3}R\d{3}C\d{2}RC\S{1,2}|V\d{3}R\d{3}C\d{2}SPC\S{3}|V\d{3}R\d"
        r"{3}C\d{2}SPH\S{3}|V\d{3}R\d{3}C\d{2}CP\S{4}|V\d{3}R\d{3}C\d{2}"
        r"HP\S{4}|V\d{3}R\d{3}C\d{2}")
    ver_groups = fusion_sphere_pattern.findall("\n".join(is_fusion_sphere))
    if ver_groups:
        return {"name": "Not Linux", "type": "Not Found", "sn": "", "version": ""}

    dev_type = ""
    sn = ""
    version = "Not Found"
    name = get_device_name(context)
    if name:
        sn = ip_addr
        version = get_product_version(context)
        dev_type = get_dev_type(context)
        logger.info("the device name is: %s, the type is : %s, the sn is : %s,"
                    " the version is : %s" % (name, dev_type, sn, version))
    return {"name": name, "type": dev_type, "sn": sn, "version": version, "ip": ip_addr}


def get_dev_type(context):
    """
    获取操作系统类型
    :param context: 上下文
    :return:  操作系统类型
    """
    dev_type = get_type(context)
    if not dev_type:
        dev_type = "Unknown"
    return dev_type


def get_type(context):
    linux_system_cmds = ["cat /etc/*release", "cat /etc/issue"]
    for linux_system_cmd in linux_system_cmds:
        system_info = get_type_info(linux_system_cmd, context)
        if "no such file or directory" not in system_info.lower():
            return get_system_type(system_info, linux_system_cmd, context)
    return ""


def get_type_info(linux_system_cmd, context):
    context["command"] = linux_system_cmd
    return context["command"] + "\n" + "".join(get_cmd_ret(context))


def get_system_type(op_sys_info, linux_system_cmd, context):
    dev_type = ""
    op_sys_info_lower = op_sys_info.lower()
    tem_line = op_sys_info.splitlines()
    if 'asianux' in op_sys_info_lower:
        dev_type = get_type_asianux(tem_line)
    elif 'debian' in op_sys_info_lower:
        dev_type = get_type_debian(tem_line)
    elif 'oracle linux' in op_sys_info_lower:
        dev_type = get_type_oracle_linux(linux_system_cmd, tem_line)
    elif 'suse' in op_sys_info_lower:
        dev_type = get_type_suse(linux_system_cmd, tem_line)
    elif 'red hat' in op_sys_info_lower:
        dev_type = get_type_oracle_red_hat(linux_system_cmd, tem_line)
    elif 'centos' in op_sys_info_lower:
        dev_type = get_type_centos(tem_line)
    elif 'xenserver' in op_sys_info_lower:
        dev_type = get_type_xenserver(tem_line, context)
    elif 'ubuntu' in op_sys_info_lower:
        dev_type = get_type_ubuntu(tem_line, context)
    return dev_type


def get_type_oracle_linux(linux_system_cmd, tem_line):
    if linux_system_cmd == "cat /etc/*release":
        return get_type_oracle_linux_release(tem_line)
    else:
        return get_type_oracle_linux_issue(tem_line)


def get_type_suse(linux_system_cmd, tem_line):
    if linux_system_cmd == "cat /etc/*release":
        return get_type_suse_release(tem_line)
    else:
        return get_type_suse_issue(tem_line)


def get_type_oracle_red_hat(linux_system_cmd, tem_line):
    if linux_system_cmd == "cat /etc/*release":
        return get_type_oracle_red_hat_release(tem_line)
    else:
        return get_type_oracle_red_hat_issue(tem_line)


def get_type_asianux(tem_line):
    for i in range(0, len(tem_line)):
        if 'Asianux' in tem_line[i]:
            return 'Asianux ' + tem_line[i].split()[2]


def get_type_debian(tem_line):
    for i in range(0, len(tem_line)):
        if 'Debian' in tem_line[i]:
            return 'Debian ' + tem_line[i].split()[2]


def get_type_oracle_linux_release(tem_line):
    for i in range(0, len(tem_line)):
        if 'Oracle Linux' in tem_line[i]:
            info_arrays = tem_line[i].split()
            match_version = re.findall(r'\d+.\d+', tem_line[i], re.I)
            version = info_arrays[-1] if len(match_version) < 1 else \
                match_version[0]
            version = info_arrays[4] if len(
                info_arrays) > 4 else version
            return 'Oracle Linux ' + version


def get_type_oracle_linux_issue(tem_line):
    for i in range(0, len(tem_line)):
        if 'Oracle Linux' in tem_line[i]:
            return 'Oracle Linux ' + tem_line[i].split()[4]


def get_type_suse_release(tem_line):
    version = "0"
    patch_version = "0"
    for i in range(0, len(tem_line)):
        if tem_line[i].startswith("VERSION") and version == '0':
            version = tem_line[i].split("=")[1].strip()
        if tem_line[i].startswith("PATCHLEVEL ="):
            patch_version = tem_line[i].split("=")[1].strip()
    if "0" == patch_version:
        return 'SUSE %s' % (version.replace("\"", ""))
    else:
        return 'SUSE %s SP%s' % (version, patch_version)


def get_type_suse_issue(tem_line):
    for i in range(0, len(tem_line)):
        if 'SUSE' in tem_line[i]:
            return "SUSE " + tem_line[i].split()[6] + " " + \
                       tem_line[i].split()[7]


def get_type_oracle_red_hat_release(tem_line):
    for i in range(0, len(tem_line)):
        if 'Red Hat' in tem_line[i] and "=" not in tem_line[i]:
            tempsectors = tem_line[i].split()
            version_index = min(6, len(tempsectors) - 1)
            return "Red Hat " + tempsectors[version_index]


def get_type_oracle_red_hat_issue(tem_line):
    for i in range(0, len(tem_line)):
        if 'Red Hat' in tem_line[i]:
            return "Red Hat " + tem_line[i].split()[6]


def get_type_centos(tem_line):
    for i in range(0, len(tem_line)):
        if 'CentOS' in tem_line[i]:
            dev_type = "CentOS " + tem_line[i].split()[2]
            if dev_type == 'CentOS release':
                dev_type = "CentOS " + tem_line[i].split()[3]
            return dev_type


def get_type_xenserver(tem_line):
    for i in range(0, len(tem_line)):
        if 'XenServer' in tem_line[i]:
            return "XenServer " + re.split(' |-', tem_line[i])[2]


def get_type_ubuntu(tem_line, context):
    for i in range(0, len(tem_line)):
        if 'Ubuntu' in tem_line[i]:
            return fetch_ubuntu_base_info(context)


def fetch_ubuntu_base_info(context):
    """
    ubuntu_base
    :param context: 上下文
    :return: ubuntu_base
    """
    context["command"] = "cat /etc/issue"
    cli_ret = get_cmd_ret(context)
    cli_ret_lists = cli_ret[0].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


def get_device_name(context):
    """
    获取device_name
    :param context: 上下文
    :return: 设备名字
    """
    context["command"] = "uname -a"
    device_name_info = get_cmd_ret(context)
    device_name = ""
    for line in device_name_info:
        if line.lower().startswith("linux"):
            device_name = "Linux"
            break
    logger.info("the device name is:" + device_name)
    return device_name


def get_product_version(context):
    """
    获取操作系统版本号
    :return:  操作系统版本号
    """
    product_version = ''
    context["command"] = "cat /proc/version"
    op_sys_ver = get_cmd_ret(context)
    for line in op_sys_ver:
        if "linux" in line.lower():
            product_version = re.split(' |-', line)[2].strip()
    return product_version
