# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import os
import sys
reload(sys)
sys.setdefaultencoding('utf-8')

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
from util import get_cmd_ret


def execute(context):
    """
    添加主机获取信息
    :param context: context
    :return: cliRet
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    global ip_addr
    logger = context.get("Logger")
    ip_addr = get_windows_ip_addr(context)

    dev_type = ''
    sn = ''
    version = ''
    name = get_device_name(context)
    if name:
        sn = ip_addr
        dev_type = name
        version = "1.0.1"
        logger.info("the device name is: %s, the type is : %s, the sn is : %s,"
                    " the version is : %s" % (name, dev_type, sn, version))
    return {"name": name, "type": dev_type, "sn": sn, "version": version, "ip": ip_addr}


def get_device_name(context):
    """
    获取device_name
    :param context: context
    :return: device_name
    """
    context["command"] = "wmic OS get Caption /value"
    device_name_info = get_cmd_ret(context)
    if "windows" in "".join(device_name_info).lower():
        return "Windows"
    logger.info("can not get windows device name.")
    return ""


def get_real_ip(context):
    """
    获取windows主机的真实ip地址
    :param context: context
    :return: cliRet
    """
    context["command"] = "ipconfig /all"
    system_info = get_cmd_ret(context)
    for line in system_info:
        if line.strip().startswith("IPv4"):
            return line.split(":")[-1].split("(")[0].strip()
    return ""


def get_windows_ip_addr(context):
    """
    获取windows主机的ip地址
    :param context: context
    :return: cliRet
    """
    real_ip = get_real_ip(context)
    if real_ip:
        return real_ip
    context["command"] = "hostname"
    system_info = get_cmd_ret(context)
    host_name = "".join(system_info).strip()
    file_name = os.path.basename(str(context.get('datafile', ''))).rstrip(".data")
    if host_name:
        return file_name + "_" + host_name
    return file_name
