﻿# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import re
import time
import traceback

CLI = None
LANGUAGE = None
IP_ADDR = None

EXE_CMD_FAILED = "TOOLKIT_EXE_CMD_FAILED"
SEND_CMD_TIME_OUT = "TOOLKIT_SEND_CMD_TIME_OUT"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    logger = context.get("Logger")
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    dev_type = ''
    sn = ''
    version = 'Not Found'

    name = check_and_get_result(get_device_name())
    if name:
        try:
            sn = check_and_get_result(get_serial_number())
            dev_type = check_and_get_result(get_dev_type())
            version = check_and_get_result(get_product_version())
            logger.info("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
        except:
            logger.error("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
            logger.error("the except info is:" + traceback.format_exc())
    else:
        name = "Not Solaris"
        dev_type = ""
        sn = ""
        version = ""

    return {"name": name, "type":dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmdWithTimout("cat /etc/release", 60)

    verPattern = re.compile(r"(Solaris [0-9.]* )")
    for line in op_sys_info.splitlines():
        verInfo = verPattern.search(line)
        if verInfo:
            dev_type = verInfo.group(1)
            break

    if "Solaris " != dev_type:
        fun_flag = CHECK_PASS
    return fun_flag, dev_type, fun_err_msg


# need to explain this function.
def fetch_ubuntu_base_info():
    cli_ret = CLI.execCmdWithTimout("cat /etc/issue", 60)
    cli_ret_list = cli_ret.splitlines()
    cli_ret_lists = cli_ret_list[1].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    device_name = ''
    cli_ret = CLI.execCmdWithTimout("uname -a", 60)
    for line in cli_ret.splitlines():
        if line.lower().startswith("sunos"):
            device_name = "Solaris"
            break
    logger.info("the device name is:" + device_name)

    # here
    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    cli_flag = CHECK_FAIL
    fun_err_msg = ''
    op_sys_info = CLI.execCmdWithTimout("cat /etc/release", 60)
    product_version = op_sys_info.splitlines()[1].split()[2].strip()
    if '' != product_version:
        fun_flag = CHECK_PASS
    return cli_flag, product_version, fun_err_msg

def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S', time.localtime(time.time()))
    t = t.replace('-', '')
    return t

#need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str = ""
    mac_arr = ""
    lan_num = CLI.execCmdWithTimout("netstat -in|grep " + IP_ADDR + " |awk '{print $1}'", 60)
    lan_num_array = [] if lan_num == None else lan_num.splitlines()
    if len(lan_num_array) < 2 :
        serial_number = get_time_str() + IP_ADDR
        return fun_flag, serial_number, fun_err_msg
    mac_address = CLI.execCmdWithTimout("ifconfig " + lan_num.splitlines()[1] + "|grep ether|awk '{print $2}'", 60)
    macLines = mac_address.splitlines()
    if EXE_CMD_FAILED not in macLines and SEND_CMD_TIME_OUT not in macLines:
        mac_arr = macLines[1].strip().split(':') if len(macLines) > 1 else []
    for mac in mac_arr:
        if(len(mac) == 1):
            mac_str = "0"
        else:
            mac_str += mac
    if "0" == mac_str:
        serial_number = get_time_str() + IP_ADDR
    else:
        serial_number = mac_str + IP_ADDR
    if '' == serial_number:
        serial_number = "SN" + get_time_str() + IP_ADDR
        if LANGUAGE == "zh":
            fun_err_msg = u"获取设备版本失败。"
        else:
            fun_err_msg = "Get product version failed."

    serial_number = serial_number.replace('.', '')

    return fun_flag, serial_number, fun_err_msg
