﻿# -*- coding: UTF-8 -*-
import sys
import time
import os
import traceback
import re

class log():

    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL = 5, skipLastLevel = True):
        #从堆栈中获取调用函数和行号

        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1

        #生成函数调用关系
        callerInfo = ""
        for _ in range(0, MAX_CALLER_LEVEL):

            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" + str(lineNumber) + "]" + callerInfo
            else:
                break

            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break

        #返回函数调用关系
        return callerInfo

    @staticmethod
    def debug(context, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：context=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            return False

    @staticmethod
    def error(context, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：context=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            return False

    @staticmethod
    def info(context, info):
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            return False

    @staticmethod
    def warn(context, info):
        logInfo = info + log.getCallerInfo()
        if context and "Logger" in context:
            context.get("Logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            return False


def get_cmd_ret(context):
    """
       从txt文件获取命令回显
       :param context:  上下文
       :return: 命令回显
       """
    cmd_ret_list = []
    flag = False
    command = context.get("command")
    file_path = context.get("datafile")
    start_line = "StartCmd:" + command
    end_line = "EndCmd:" + command
    logger = context.get("Logger")
    with open(file_path, 'r') as file_handle:
        for line in file_handle:
            if line.strip() == start_line:
                flag = True
                continue
            if line.strip() == end_line:
                break
            if flag:
                cmd_ret_list.append(get_utf8_line(line, logger))
    return cmd_ret_list


def get_time_str():
    """
    获取当前时间
    :return: 当前时间
    """
    return time.strftime('%Y%m%d%H%M%S', time.localtime(time.time()))


def get_ip_addr(context):
    """
    获取ip(非windows)
    :param context: 上下文
    :return: ip
    """
    is_real_ip, ip = get_real_ip(context)
    if is_real_ip:
        return ip
    host_name = get_host_name(context)
    data_file = unicode(str(context.get('datafile', '')), 'utf-8')
    file_name = os.path.basename(data_file).rstrip(".data")
    if host_name:
        return file_name + "_" + host_name
    return file_name


def get_host_name(context):
    """
    获取主机名
    :param context: 上下文
    :return: 主机名
    """
    context["command"] = "uname -a"
    name_info = get_cmd_ret(context)
    name_lines = filter(lambda name_item: name_item.strip(), name_info)
    if not name_lines:
        return ""
    return get_split_item(re.split("\\s+", name_lines[0]), 1)


def get_split_item(split_items, index):
    """
    安全获取split分割的字符
    :param split_items: split_items
    :param index: index
    :return: item
    """
    if index + 1 > len(split_items):
        return ""
    else:
        return split_items[index]


def get_utf8_line(line, logger):
    """
    转为utf8，异常数据转码错误返回空
    :param line:  回文行
    :param logger:  日志打印
    :return: 命令回显
    """
    try:
        return unicode(line, "utf-8")
    except Exception:
        logger.error("get error, line:%s ,reason:%s" % (line, str(traceback.format_exc())))
        return ""


def get_real_ip(context):
    """
    获取真实ip
    :param context: 上下文
    :return: ip
    """
    context["command"] = "self_define_cmd_basicinfo"
    ip_info = get_cmd_ret(context)
    ip = ""
    if len(ip_info) == 2:
        ip = ip_info[-1].strip()
    return is_ip(ip), ip


def is_ip(ip):
    """
    是否是真实ip地址（非127.0.0.1和0.0.0.0）
    :param ip: ip地址
    :return: 是否是真实ip地址
    """
    if "127.0.0.1" == ip.strip() or "0.0.0.0" == ip.strip():
        return False
    for item in ip.split("."):
        if not item.isdigit():
            return False
    return True
