﻿# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import re
import time
import traceback

CLI = None
LANGUAGE = None
IP_ADDR = None


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    logger = context.get("Logger")
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    name = check_and_get_result(get_device_name())
    dev_type = ''
    sn = ''
    version = 'Not Found'
    if name:
        try:
            sn = check_and_get_result(get_serial_number())
            dev_type = check_and_get_result(get_dev_type())
            version = check_and_get_result(get_product_version())
            logger.info("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
        except:
            logger.error("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
            logger.error("the except info is:" + traceback.format_exc())

    else:
        name = "Not VMware"
        dev_type=""
        sn=""
        version=""

    return {"name": name, "type":dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmdWithTimout("vmware -v", 60)
    dev_type = op_sys_info.splitlines()[1].split()[1].strip()+" "+op_sys_info.splitlines()[1].split()[2].strip()
    if '' != dev_type:
        fun_flag = CHECK_PASS
    return fun_flag, dev_type, fun_err_msg


# need to explain this function.
def fetch_ubuntu_base_info():
    cli_ret = CLI.execCmdWithTimout("cat /etc/issue", 60)
    cli_ret_list = cli_ret.splitlines()
    cli_ret_lists = cli_ret_list[1].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    device_name = ''
    cli_ret = CLI.execCmdWithTimout("uname -a", 60)
    for line in cli_ret.splitlines():
        if line.lower().startswith("vmkernel"):
            device_name = "VMware"
            break
    logger.info("the device name is:" + device_name)

    # here
    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmdWithTimout("vmware -v", 60)
    product_version = op_sys_info.splitlines()[1].split()[2].strip()
    if '' != product_version:
        fun_flag = CHECK_PASS
    return fun_flag, product_version, fun_err_msg

#need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str = "0"
    mac_address = CLI.execCmdWithTimout("esxcfg-vmknic -l|grep " + IP_ADDR, 60)
    macPattern = re.compile(r" (([0-9a-fA-F]{1,2}:){4,}[0-9a-fA-F:]*) ")
    for line in mac_address.splitlines():
        macAddress = macPattern.search(line)
        if macAddress:
            mac_str = macAddress.group(1).replace(":", "")
            break

    if "0"==mac_str:
        serial_number = get_time_str()+IP_ADDR
    else:
        serial_number = mac_str + IP_ADDR
        
    if '' != serial_number:
        fun_flag = CHECK_PASS
    else:
        serial_number = "SN" + get_time_str()+IP_ADDR
    serial_number = serial_number.replace('.', '')
        
    return fun_flag, serial_number, fun_err_msg

def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S',time.localtime(time.time()))
    t = t.replace('-', '')
    return t
 
#need to explain this function.
def get_serial_number_by_linux():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str=""
    mac_address = ''
    if_config_str = CLI.execCmdWithTimout("/sbin/ifconfig", 60)
    ip_link_show = CLI.execCmdWithTimout("/sbin/ip link show", 60)
    
    if ip_link_show.find("TOOLKIT_EXE_CMD_FAILED") >0:
        ip_link_show = CLI.execCmdWithTimout("ip link show", 60)

    temp_list = if_config_str.splitlines()
    temp_list_2 = ip_link_show.splitlines()

    for i in range(0, len(temp_list)):
        if IP_ADDR in temp_list[i]:
            eth_name = temp_list[i - 1].split()[0]
            if eth_name.find(":")>=0:
                eth_name = eth_name.split(':')[0]

            eth_name = eth_name.split(':')[0]
            for i in range(0, len(temp_list_2)):
                if eth_name in temp_list_2[i]:
                    mac_address = temp_list_2[i+1].split()[1]
                    break
            mac_arr = mac_address.strip().split(':')

            for mac in mac_arr:
                if(len(mac)==1):
                    mac_str="0"
                else:
                    mac_str+=mac
            if "0"==mac_str:
                serial_number = get_time_str()+IP_ADDR
            else:
                serial_number = mac_str + IP_ADDR
            fun_flag = CHECK_PASS
            break
    if ''==serial_number:
        serial_number = "SN" + get_time_str()+IP_ADDR
        if LANGUAGE == "zh":
            fun_err_msg = u"获取设备版本失败。"
        else:
            fun_err_msg = "Get product version failed."
    
    serial_number = serial_number.replace('.', '')
    
    return fun_flag, serial_number, fun_err_msg
