# -*- coding: UTF-8 -*-
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re
import traceback

CLI = None
LANGUAGE = None
IP_ADDR = None

#huawei存储相关信息
display_cmd_command_name = "uname -a"
display_cmd_command_type = "uname -a"
display_cmd_command_version = "uname -r"
display_cmd_command_sn = "ifconfig -a"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global logger
    logger = context.get("Logger")
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()
    dev_type = ''
    sn = ''
    version = 'Not Found'
    name =getXenserverName()
    if "xenserver" in name.lower():
        name="XenServer"
        try:
            dev_type = getXenserverType()
            sn = getXenserverSN()
            version = getXenserverVersion()
            logger.info("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
        except:
            logger.error("the device name is: %s, the type is : %s, the sn is : %s, the version is : %s" % (name, dev_type, sn, version))
            logger.error("the except info is:" + traceback.format_exc())

    else:
        name="not Xenserver"
        dev_type=""
        sn=""
        version=""
    return {"name": name, "type":dev_type, "sn": sn, "version": version}

def getXenserverName():
    cli_ret = CLI.execCmdWithTimout(display_cmd_command_name, 60)
    cli_ret_list = cli_ret.splitlines()
    xenserver_name=cli_ret_list[1].strip()
    return xenserver_name

def getXenserverType():
    cli_ret = CLI.execCmdWithTimout(display_cmd_command_type, 60)
    cli_ret_list = cli_ret.splitlines()
    xenserver_type=cli_ret_list[1].split()[0]+" "+cli_ret_list[1].split()[1]
    return xenserver_type


def getXenserverVersion():
    cli_ret = CLI.execCmdWithTimout(display_cmd_command_version, 60)
    cli_ret_list = cli_ret.splitlines()
    xenserver_version=cli_ret_list[1]
    return xenserver_version

def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S',time.localtime(time.time()))
    t = t.replace('-', '')
    return t    

def getXenserverSN():
    cli_ret = CLI.execCmdWithTimout(display_cmd_command_sn, 60)
    cli_ret_list = cli_ret.splitlines()
    temp=""
    for i in range(len(cli_ret_list)):
        if "hwaddr" in cli_ret_list[i].lower():
            temp=cli_ret_list[i]
            break
    templst=temp.split()
    templen=len(templst)
    xenserver_sn=''
    if templen > 0:
        xenserver_sn = templst[templen-1]
    #是否获取到mac
    if (len(xenserver_sn)>1):
        xenserver_sn = xenserver_sn + IP_ADDR
    else:
        xenserver_sn = get_time_str() + IP_ADDR
    xenserver_sn=xenserver_sn.replace(':','')
    if ''==xenserver_sn:
        xenserver_sn = "SN" + get_time_str()+IP_ADDR
    
    xenserver_sn = xenserver_sn.replace('.', '')
    return xenserver_sn
