#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import json
import traceback

NA = 'NA'
system_info_api = 'system/instances?fields=id,model,serialNumber'
basic_system_info_api = 'basicSystemInfo/instances'


def execute(context):
    """
    获取Unity系统信息执行方法
    :param context: 上下文
    :return: 系统信息
    """
    try:
        rest = context.get("SSH")
        system_info = get_system_info(rest)
        system_info["version"] = get_version(rest)
        return system_info
    except Exception:
        logger = context.get("Logger")
        logger.error("Get EMC Unity info error, reason: %s" % str(traceback.format_exc()))
        return {"name": NA, "type": NA, "sn": NA, "version": NA}


def get_system_info(rest):
    """
    获取系统信息，包含型号和序列号
    :param rest: rest连接对象
    :return: 系统信息
    """
    content = get_content(rest, system_info_api)
    model = content.get("model", NA)
    sn = content.get("serialNumber", NA)
    return {"name": "EMC", "type": model, "sn": sn}


def get_version(rest):
    """
    获取版本号
    :param rest: rest连接对象
    :return: 版本信息
    """
    return get_content(rest, basic_system_info_api).get("softwareVersion", NA)


def get_content(rest, api):
    """
    从接口回显中获取content信息，只需获取第一个
    :param rest: rest连接对象
    :param api: 接口
    :return: content信息
    """
    response = rest.sendRestWithLog("GET", api, "")
    return json.loads(response).get("entries", [{}])[0].get("content", {})
