#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
# 获取EMC_Vplex设备基本信息
import re
import json
import traceback


def execute(context):
    """
    添加Vplex设备，查询设备基本信息
    :param context:
    :return:
    """
    try:
        rest = context.get("SSH")
        sn = get_serial_number(rest)
        version = get_version(rest)
        return {"name": "EMC", "type": "Vplex", "sn": sn, "version": version}
    except Exception:
        logger = context.get("Logger")
        logger.error("Get EMC Vplex info error, reason: %s" % str(traceback.format_exc()))
        return {"name": "NA", "type": "NA", "sn": "NA", "version": "NA"}


def get_serial_number(rest):
    """
    获取设备序列号
    :param rest: rest连接
    :return: sn
    """
    json_response = rest.sendRestWithLog("POST", "cluster+summary", "")
    data = get_custom_data(json_response)
    if not data:
        return 'NA'
    start = False
    for line in data.split("\n"):
        if not start and "Name" in line and "TLA" in line:
            start = True
            continue
        if start and "----" not in line:
            items = line.split()
            return items[2].strip() if len(items) > 2 else 'NA'
    return 'NA'


def get_version(rest):
    """
    获取设备版本号
    :param rest: rest连接
    :return: version
    """
    json_response = rest.sendRestWithLog("POST", "version", "")
    data = get_custom_data(json_response)
    if not data:
        return 'NA'
    for line in data.split("\n"):
        if "Product Version" in line:
            items = re.split("\\s{2,}", line)
            return items[1].strip() if len(items) > 1 else 'NA'
    return 'NA'


def get_custom_data(json_response):
    """
    获取json回显中的数据信息
    :param json_response: rest返回的json回显信息
    :return: custom-data字段信息
    """
    json_obj = json.loads(json_response)
    return json_obj.get("response", {}).get("custom-data", "").strip()
