#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# 获取Fujistu SAN存储设备基本信息
import traceback
from toolkit.storage.scriptforstorage.discovery.data_parse_util import get_value_data
CLI = None


def execute(context):
    """
    执行主函数
    :param context: 上下文
    :return: 设备基本信息
    """
    global CLI
    CLI = context.get("SSH")
    try:
        model, sn, version = get_system_info()
        return {"name": "Fujistu", "type": model, "sn": sn, "version": version}
    except Exception:
        logger = context.get("Logger")
        logger.error("get system info error, reason:%s" % str(traceback.format_exc()))
    return {"name": "", "type": "", "sn": "", "version": ""}


def get_system_info():
    """
    获取设备类型、版本号
    :return: 版本号
    """
    model, sn, version = "", "", ""
    cli_result = CLI.execCmdHasLogTimout("show enclosure-status", 60)
    model_key_word = "Model Name"
    sn_key_word = "Serial Number"
    version_key_word = "Firmware Version"
    for line in cli_result.splitlines():
        line = line.strip()
        if not model and line.startswith(model_key_word):
            model = data_format(get_value_data(line, model_key_word))
            continue
        if not sn and line.startswith(sn_key_word):
            sn = data_format(get_value_data(line, sn_key_word))
            continue
        if not version and line.startswith(version_key_word):
            version = data_format(get_value_data(line, version_key_word))
            continue
    return model, sn, version


def data_format(data):
    """
    数据格式化，去除前后的[]符号
    :param data: 数据
    :return: 处理后的数据
    """
    return data.lstrip("[").rstrip("]")
