# -*- coding: UTF-8 -*-
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re

CLI = None
LANGUAGE = None
IP_ADDR = None

#交换机型号
display_cmd_command = "showsys -d"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
  
    LANGUAGE = "en"

    hpObj = hp_Entity()
    hpObj = getStorageInfo()
    dev_type = hpObj.get_hpdevtype()
    sn = hpObj.get_hpsn()
    version = hpObj.get_hpversion()
    name = hpObj.get_hpname()
    
    return {"name": name, "type": dev_type, "sn": sn, "version": version}

def getStorageInfo():
    cli_ret = CLI.execCmdHasLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    hpObj = hp_Entity()
    
    for line in cli_ret_list:
        if 'system' in line.lower() and 'model' in line.lower():
            tempArr = []
            tempArr = re.split('\\s+', line)
            tempArr = re.split(':', line)
            if 2 == len(tempArr):
                hpObj.set_hpdevtype(tempArr[1].strip())
                hpObj.set_hpname('HP')
        if 'serial' in line.lower() and 'number' in line.lower():
            tempArr = []
            tempArr = re.split('\\s+', line)
            if 4 == len(tempArr):
                hpObj.set_hpsn(tempArr[3])
                break
    return hpObj

class hp_Entity:
    __hpversion = 'NA'
    __hpsn = 'NA'
    __devtype = 'NA'
    __hpname = 'NA'
    
    def get_hpversion(self):
        return self.__hpversion
    def get_hpsn(self):
        return self.__hpsn
    def get_hpdevtype(self):
        return self.__devtype
    def get_hpname(self):
        return self.__hpname
    
    def set_hpversion(self,version):
        self.__hpversion = version
    def set_hpsn(self,sn):
        self.__hpsn = sn
    def set_hpdevtype(self,devtype):
        self.__devtype = devtype
    def set_hpname(self,name):
        self.__hpname = name
        
