# -*- coding: UTF-8 -*-
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re

CLI = None
LANGUAGE = None
IP_ADDR = None

#交换机型号
display_cmd_command1 = "lssystem  -delim :"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")

    ibmObj = getStorageInfo()
    dev_type = ibmObj.get_ibmdevtype()
    sn = ibmObj.get_ibmsn()
    version = ibmObj.get_ibmversion()
    name = ibmObj.get_ibmname()
    
    return {"name": name, "type": dev_type, "sn": sn, "version": version}

def getStorageInfo():
    cli_ret1 = CLI.execCmdHasLogTimout(display_cmd_command1, 60)
    cli_ret_list1 = cli_ret1.splitlines()

    ibmObj = ibm_Entity()
    
    for line in cli_ret_list1:
        if line.startswith("id:"):
            ibmObj.set_ibmsn(line.split(":")[1])
            ibmObj.set_ibmname("IBM")
        if line.startswith("product_name:"):
            ibmObj.set_ibmdevtype(line.split(":")[1].strip())
    # 对于没有product_name 字段的存储，给定一个默认字段也让收集
    if ibmObj.get_ibmdevtype() == "NA":
        ibmObj.set_ibmdevtype("IBM_TYPE")
    return ibmObj

class ibm_Entity:
    __ibmversion = 'NA'
    __ibmsn = 'NA'
    __devtype = 'NA'
    __ibmname = 'NA'
    
    def get_ibmversion(self):
        return self.__ibmversion
    def get_ibmsn(self):
        return self.__ibmsn
    def get_ibmdevtype(self):
        return self.__devtype
    def get_ibmname(self):
        return self.__ibmname
    
    def set_ibmversion(self,version):
        self.__ibmversion = version
    def set_ibmsn(self,sn):
        self.__ibmsn = sn
    def set_ibmdevtype(self,devtype):
        self.__devtype = devtype
    def set_ibmname(self,name):
        self.__ibmname = name
        
