#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# 获取NetApp SAN存储设备基本信息

import traceback
from toolkit.storage.scriptforstorage.discovery.data_parse_util import get_value_data
CLI = None


def execute(context):
    """
    执行主函数
    :param context: 上下文
    :return: 设备基本信息
    """
    global CLI
    CLI = context.get("SSH")
    try:
        dev_type, sn = get_dev_type_sn()
        return {"name": "NetApp", "type": dev_type, "sn": sn, "version": get_version()}
    except Exception:
        context.get("Logger").error("get huawei system info error, reason:%s" % str(traceback.format_exc()))
    return {"name": "", "type": "", "sn": "", "version": ""}


def get_version():
    """
    获取版本号
    :return: 版本号
    """
    cli_result = CLI.execCmdHasLogTimout("version", 60)
    return cli_result.split(":")[0].split()[-1]


def get_dev_type_sn():
    """
    获取设备型号、sn
    :return: 版本号
    """
    dev_type, sn = "", ""
    cli_result = CLI.execCmdHasLogTimout("system show -instance", 60)
    model_key_word = "Model:"
    sn_key_word = "Serial Number:"
    for line in cli_result.splitlines():
        line = line.strip()
        if not dev_type and line.startswith(model_key_word):
            dev_type = get_value_data(line, model_key_word)
            continue
        if not sn and line.startswith(sn_key_word):
            sn = get_value_data(line, sn_key_word)
            continue
        if dev_type and sn:
            return dev_type, sn
    return dev_type, sn
