#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# 获取PureStorage SAN存储设备基本信息

import traceback

CLI = None


def execute(context):
    """
    执行主函数
    :param context: 上下文
    :return: 设备基本信息
    """
    global CLI
    CLI = context.get("SSH")
    try:
        dev_type, version = get_type_version()
        sn = get_sn()
        return {"name": "PureStorage", "type": dev_type, "sn": sn, "version": version}
    except Exception:
        logger = context.get("Logger")
        logger.error("get system info error, reason:%s" % str(traceback.format_exc()))
    return {"name": "", "type": "", "sn": "", "version": ""}


def get_type_version():
    """
    获取设备类型、版本号
    :return: 版本号
    """
    cli_result = CLI.execCmdHasLogTimout("purearray list --controller", 60)
    for line in cli_result.splitlines():
        items = line.strip().split()
        if len(items) == 6 and items[1] == "array_controller":
            return items[3], items[4]
    return "", ""


def get_sn():
    """
    获取设备sn
    :return: sn
    """
    cli_result = CLI.execCmdHasLogTimout("purearray list", 60)
    header_flag = False
    for line in cli_result.splitlines():
        items = line.strip().split()
        if len(items) > 1 and items[1] == "ID":
            header_flag = True
            continue
        if header_flag and len(items) > 1:
            return items[1]
    return ""
