# -*- coding: UTF-8 -*-
def execute(context):
    """
    Function name      : execute
    Function describe  : 获取交换机信息
    Input              : context
    """

    global CLI
    CLI = context.get("SSH")

    switchType, serialNumber = getSwitchInfo()
    switchName = 'Brocade' if switchType else "Not Brocade"
    version = getSwitchVersion()

    return {"name": switchName, "type":switchType, "sn": serialNumber, "version": version}

def getSwitchInfo():
    '''
    @summary: 获取交换机类型, SN
    @return: switchType, switchWwn
    '''
    cliRet = CLI.execCmdWithTimout("switchshow", 60)
    cliRetList = cliRet.splitlines()

    switchType = ''
    switchWwn = ''
    for line in cliRetList:
        if line.startswith("switchType:"):
            switchType = line.split(":")[-1].strip()
            continue
        if line.startswith("switchWwn:"):
            switchWwn = line[line.index(":") + 1:].strip().replace(":", "")
        if switchType and switchWwn:
            break
    return switchType, switchWwn

def getSwitchVersion():
    '''
    @summary: 获取交换机版本号
    @return: switchVersion
    '''

    cliRet = CLI.execCmdWithTimout("version", 60)
    cliRetList = cliRet.splitlines()

    switchVersion = ''
    for line in cliRetList:
        if line.startswith("Fabric OS:"):
            switchVersion = line.split(":")[-1].strip()
            break
    return switchVersion
