# -*- coding: UTF-8 -*-
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re
import base64

CLI = None
LANGUAGE = None
IP_ADDR = None
EXE_CMD_FAILED = "TOOLKIT_EXE_CMD_FAILED"
SEND_CMD_TIME_OUT = "TOOLKIT_SEND_CMD_TIME_OUT"

#交换机型号
display_cmd_command="show version"
cmd_macaddr = "show module"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()
    name = check_and_get_result(getSwitchType())
    if 'cisco' in name.lower():
        name="Cisco"
    else:
        name='Not Cisco'

    dev_type = check_and_get_result(getSwitchType())
    sn = check_and_get_result(getSwitchWWN(IP_ADDR,context))
    version = check_and_get_result(getSwitchVersion())

    return {"name": name, "type":dev_type, "sn": sn, "version": version}

# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)
    
def getSwitchType():
    '''
    @summary: 获取交换机类型
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机类型
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdHasLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    
    switchType = ""
    arrayIndex = -1;
    for line in cli_ret_list:
        arrayIndex = arrayIndex + 1
        fields = line.strip()
        
        if fields == "Hardware":
            if len(cli_ret_list) > arrayIndex :
                switchTypeStr = cli_ret_list[arrayIndex + 1]
                if "(" in switchTypeStr :
                    switchType = switchTypeStr[:switchTypeStr.index("(")].strip()
                else :
                
                    switchType = switchTypeStr.strip()
        
    # here
    if len(switchType) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机类型失败。"
        else:
            fun_err_msg = "Get switch type failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchType, fun_err_msg


def getSwitchVersion():
    '''
    @summary: 获取交换机版本号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机版本号
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
  
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdHasLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    
    switchVersion = ""
    for line in cli_ret_list:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "System version":
            switchVersion = fieldValue
            
    # here
    if len(switchVersion) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机版本号失败。"
        else:
            fun_err_msg = "Get switch version failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchVersion, fun_err_msg


def getSwitchWWN(IP_ADDR_DEV,context):
    '''
    @summary: 获取交换机WWN号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机WWN号
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    
    show module
    Mod  MAC-Address(es)                         Serial-Num
    ---  --------------------------------------  ----------
    1    00-1d-70-b2-86-00 to 00-1d-70-b2-86-03  JAE13062S8U
    2    00-13-80-a8-ed-ac to 00-13-80-a8-ed-af  JAE130313TT
    7    00-1a-e2-03-68-b8 to 00-1a-e2-03-68-bb  JAE114526RV
    8    00-1a-e2-03-69-24 to 00-1a-e2-03-69-27  JAE11441ZDZ
    '''   
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdHasLogTimout(cmd_macaddr, 60)
    cli_ret_list = cli_ret.splitlines()
    
    tempWwn = ""
    switchWwn = ""
    try:
        for i,line in enumerate(cli_ret_list):
            if ('mac' in line.lower()) and ('address' in line.lower()) and ('---' in cli_ret_list[i+1]):
                tempWwn = cli_ret_list[i+2]
                break
        if('-' in tempWwn):
            max = 18
            while(True):
                if(len(tempWwn) > max):
                    tempWwn = tempWwn.replace('-','')
                    tempWwn = tempWwn[1:max]
                    tempWwn = tempWwn.strip()
                    break
                else:
                    max = max -1
            if(None != IP_ADDR_DEV):
                if '.' in IP_ADDR_DEV:
                    IP_ADDR_DEV = IP_ADDR_DEV.replace('.','')
                    switchWwn = tempWwn +IP_ADDR_DEV
                else:
                    switchWwn = tempWwn +IP_ADDR_DEV
    except:
        switchWwn = 'SN' + IP_ADDR_DEV
        context.get("dev").setSnFail(False)  
    
    if (EXE_CMD_FAILED in switchWwn) or (SEND_CMD_TIME_OUT in switchWwn):
        switchWwn = 'SN' + getBase64Sn(IP_ADDR_DEV)
        context.get("dev").setSnFail(False)
        switchWwn = switchWwn.replace('.', '')
        return fun_flag, switchWwn, fun_err_msg
    
    if len(switchWwn) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机类型失败。"
        else:
            fun_err_msg = "Get switch type failed."
        switchWwn = 'SN' + getBase64Sn(IP_ADDR_DEV)
        
        context.get("dev").setSnFail(False)
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchWwn, fun_err_msg


def getBase64Sn(serial_number):
    #sn查询失败则用ip地址base64加密后的值作为sn,以下是替换掉特殊字符
    serial_number = base64.encodestring(serial_number)
    serial_number = serial_number.replace('=','')
    serial_number = serial_number.replace('\n','')
    serial_number = serial_number.replace('+','')
    serial_number = serial_number.replace('/','')
    serial_number = serial_number.upper()
    #如果加密后密文太长则只取前面几位
    if len(serial_number) >12:
        serial_number = serial_number[0:12]
    return serial_number






