# -*- coding: UTF-8 -*-
import re
import time
import resource
import config
from frame.cli import cliUtil
from frame.context import contextUtil
import os
import logger
from defusedxml import ElementTree
import time
import threading
import java.lang.Exception as JException
STATUS_NORMAL = "Normal"
STATUS_FAULT = "Fault"
STATUS_ONLINE = "Online"
STATUS_RUNNING = "Running"
STATUS_BALANCING = "Balancing"
STATUS_CHARGING = "Charging"
STATUS_DISCHARGING = "Discharging"
STATUS_ENABLED = "Enabled"
STATUS_YES = "Yes"
STATUS_NO = "No"
STATUS_LINK_UP = "Link Up"
STATUS_LINK_DOWN = "Link Down"
STATUS_ON = "On"
STATUS_OFF = "Off"
STATUS_START = "Start"
STATUS_SYNCHRONIZING = "Synchronizing"
STATUS_PAUSE = "Pause"
STATUS_FORCE_STARTED = "Force Started"

SLEEP_TIMES = 30
PORTS_BIT_ERROR_SPEC = 60
PORTS_BIT_ERROR_INTERVAL = 10
SERIAL_NUMBER_LENGTH = 20
THRESHOLD_BBU_REMAINING_LIFETIME = 60
THRESHOLD_CONTRL_CPU_USAGE = 80

RESULT_PASS = 0
RESULT_NOTPASS = 1
RESULT_NOCHECK = 2
RESULT_NOSUPPORT = 3
RESULT_WARNING = 4

FILE_SUFFIX = "."

PROGRESS_NUM_1 = 1
PROGRESS_NUM_5 = 5
PROGRESS_NUM_10 = 10
PROGRESS_NUM_15 = 15
PROGRESS_NUM_20 = 20
PROGRESS_NUM_40 = 40
PROGRESS_NUM_60 = 60
PROGRESS_NUM_80 = 80
PROGRESS_NUM_MAX = 100

#进度条刷新开始标识和结束标识
PROCESS_STATE_CHECKING = "checking"
PROCESS_UPGRADE_FINISHED = "finished"

def getUpgEvaluationRs(flag, CliRet, errMsg):
    '''
    @summary: 将巡检的结果转为升级评估的结果
    '''
    
    return (cliUtil.RESULT_DICT.get(flag, "2"), CliRet, errMsg)

def getResult(list):
    '''
    @summary: 获取升级评估返回结果
    '''
    
    flag = True
    if False in list:
        flag = False
    return cliUtil.RESULT_DICT[flag]
    
def isAllSameItem(list):
    '''
    @summary: 判断列表是否存在不同的元素
    '''
    flag = "True"
    listLenth = len(list)
    for i in range(0,listLenth):
        if list[i] == "TimeOut":
            return "False"
        for j in range(1,listLenth):
            if list[i] == list[j]:
                continue
            else:
                flag = "False"
    return flag
    
        
def getLang(py_java_env):
    '''
    @summary: 从上下文中获取lang
    @param py_java_env: 上下文对象
    @return: lang
    '''
    return py_java_env.get("lang")
    
def getMsg(lang, msg, args=""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    '''
    return cliUtil.getMsg(lang, msg, args, resource.MESSAGES_DICT)

def getSymmetricalPort(port):
    '''
    @summary: 获取端口的对称端口
    @param port: 端口
    '''
    for item in [(".A", ".B"), (".B", ".A"), (".L", ".R"), (".R", ".L")]:
        item0 = item[0]
        item1 = item[1]
        if item0 in port:
            symmetricalPort = port.replace(item0, item1)
            return symmetricalPort
    return ""

def getDiskGeneralList(cli, lang):
    '''
    @summary: 获取所有磁盘信息集合
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cmd = "show disk general"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
    if checkRet[0] != True: 
        return checkRet
    cliRet = checkRet[1]
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, [], "")
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.disk.info")
        return (False, cliRet, errMsg)
    
    return (True, cliRetLinesList, "")

def hasSSDDisks(enclosureId, diskGeneralList):
    '''
    @summary: 判断框中是否下挂SSD盘
    @param enclosureId: 框id
    @param diskGeneralList: 所有磁盘信息集合
    @return: 
        True: 框中下挂SSD盘
        False: 框中没有下挂SSD盘
    '''
    for line in diskGeneralList:
        diskID = line["ID"]
        diskType = line["Type"]
        if enclosureId in diskID and diskType == "SSD":
            return True
    return False

def getEngineSet(cli, lang):
    '''
    @summary: 获取引擎集合（不包含引擎下的所有控制器健康状态和运行状态都不正常）
    @param cli: cli对象
    @param lang: 语言lang
    @return:
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，引擎集合
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cmd = "show controller general|filterColumn include columnList=Controller,Health\sStatus,Running\sStatus"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True: 
        return checkRet
    
    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.controller.info")
        return (False, cliRet, errMsg)
    
    engineSet = set()
    for retDict in cliRetLinesList:
        ctrlId = retDict["Controller"]
        healthStatus = retDict["Health Status"]
        runningStatus = retDict["Running Status"]
        
        if healthStatus == STATUS_NORMAL and runningStatus == STATUS_ONLINE:
            ctrlId = ctrlId.replace("B", "A")
            ctrlId = ctrlId.replace("D", "C") 
            engineSet.add(ctrlId)
    
    return (True, engineSet, "")

def getPCIeSwitchNum(cli, lang):
    '''
    @summary: 获取PCIe交换机个数
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，PCIe交换机个数
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            return checkRet
        
        cliRet = checkRet[1]
        dataSwitchList = []
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = getMsg(lang, "cannot.get.enclosure.info")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            logicType = line["Logic Type"]
            frameId = line["ID"]
            if not "Data Switch" in logicType:
                continue
            else:
                dataSwitchList.append(frameId)
                
        return (True, len(dataSwitchList), "")
    except:
        errMsg = getMsg(lang, "cannot.get.pcie.switch.info")
        return (False, cliRet, errMsg)
            
def checkPCIePortExists(cli, lang):
    '''
    @summary: 判断是否需要检查PCIe端口
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，需要检查PCIe端口
            flag为False时，不需要检查PCIe端口
        errMsg: 错误消息
    '''
    getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
    if getControllerIdListRet[0] != True:
        return getControllerIdListRet
    
    engSet = set([ctrlId[0] for ctrlId in getControllerIdListRet[1]])
    if len(engSet) <= 1:
        return (True, False, "")
    return (True, True, "")

        
def getBBUConfig(cli, lang):
    '''
    @summary: 获取单个引擎的BBU规格配置
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，BBU规格
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    getProductModelRet = cliUtil.getProductModel(cli, lang)
    if getProductModelRet[0] != True:
        return getProductModelRet
    
    pdtModel = getProductModelRet[1]
    
    if config.BBU_OF_ENGINE_CONFIG_DICT.has_key(pdtModel):
        return (True, config.BBU_OF_ENGINE_CONFIG_DICT.get(pdtModel), "")
    else:
        errMsg = getMsg(lang, "cannot.get.bbu.config")
        return (False, "", errMsg)

def getEngCtrlNum(enclosureID, controllerIdList):
    '''
    @summary: 获取引擎下控制器数量
    @param cli: cli对象
    @param controllerIdList: 控制器ID列表
    @return: 特定引擎下控制器数量
    '''
    
    eng = enclosureID[-1]
    engCtrlNum = len([ctrlId for ctrlId in controllerIdList if eng in ctrlId])
    if engCtrlNum % 2 != 0:
        engCtrlNum += 1
    return engCtrlNum
    
def getEnclosureFanConfig(cli, enclosureInfo, controllerIdList, highDensityDiskEnclosureIdList, lang):
    '''
    @summary: 获取风扇的规格配置
    @param cli: cli对象
    @param enclosureInfo: 机框信息
    @param highDensityDiskEnclosureIdList: 高密框集合
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，风扇的规格
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    storageTypeRet = cliUtil.getStorageType(cli, lang)
    if storageTypeRet[0] != True:
        return storageTypeRet
    product_series = storageTypeRet[1]
    
    enclosureID = enclosureInfo["ID"]
    enclosureHeight = enclosureInfo["Height(U)"]
    
    for enclosureType in ["DSW", "DAE", "ENG", "CTE"]:
        if enclosureType in enclosureID:
            if enclosureHeight == "6" and enclosureType in ["ENG", "CTE"]:
                #6U高端2C和4C场景，都需要2个辅助散热模块，风扇个数一样
                if product_series == cliUtil.SERIES_18000:
                    return (True, 12, "")
                #6U中低端2C和4C场景，风扇个数不一样
                else:
                    engCtrlNum = getEngCtrlNum(enclosureID, controllerIdList)
                    return (True, engCtrlNum * 3, "")
            else:
                daeType = "--"
                if enclosureID in highDensityDiskEnclosureIdList:
                    daeType = "high-density"
                key = (enclosureType, enclosureHeight, daeType)
                if config.FAN_CONFIG_DICT.has_key(key):
                    return (True, config.FAN_CONFIG_DICT.get(key), "")
                    
    return (False, "", getMsg(lang, "cannot.get.fan.config"))

def checkSystemStatus(cliRet, lang):
    '''
    @summary: 根据回显判断设备是否开工正常，Health Status及Running Status都要为Normal，版本号要正常
    @param cliRet: cli回显
    @param lang: 语言lang
    @return: (flag, errMsg)
        flag:
            True: 系统状态正常
            False： 系统状态异常
        errMsg: 错误消息
    '''
    healthStatus = ""
    runningStatus = ""
    productModel = ""
    productVersion = ""
    
    lineList = cliRet.splitlines()
    for line in lineList:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "Health Status":
            healthStatus = fieldValue
        elif fieldName == "Running Status":
            runningStatus = fieldValue
        elif fieldName == "Product Model":
            productModel = fieldValue
        elif fieldName == "Product Version":
            productVersion = fieldValue
    
    if len(healthStatus) == 0 or len(runningStatus) == 0:
        return (False, getMsg(lang, "cannot.get.system.info"))
    
    if len(productModel) == 0 or len(productVersion) == 0 or productModel == "--" or productVersion == "--":
        return (False, getMsg(lang, "cannot.get.product.version.info"))
    
    if healthStatus != STATUS_NORMAL:
        return (False, getMsg(lang, "system.health.status.abnormal", healthStatus))
    
    if runningStatus != STATUS_NORMAL:
        return (False, getMsg(lang, "system.running.status.abnormal", runningStatus))
    
    return (True, "")

def getRealCapacity(capacity):
    '''
    @summary: 获取数值
    '''
    matchCapacity = re.search("\d+\.?\d*", capacity)
    if matchCapacity:
        return matchCapacity.group()
    else:
        return ""

def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name
    
def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)

def checkPortsBitError(cli, cmd, ports, lang):
    '''
    @summary: 检查所有端口在特定时间段内是否有持续增加的误码
    @param cli: cli对象
    @param cmd: cli命令
    @param ports: 端口列表
    @param lang: 语言对象
    @return:
        flag:
            True: 检查通过
            False: 检查不通过
        cliRetAll: cli回显
        errMsg: 错误时的消息
    '''
    flag = True
    errMsg = ""
    cliRetAll = ""
        
    firstResultDictRet = getPortsBitErrorResultDict(cli, cmd, ports, lang)
    firstCliRet = firstResultDictRet[1]
    if firstResultDictRet[0] != True:
        return (firstResultDictRet[0], firstCliRet, firstResultDictRet[2])
    firstResultDict = firstResultDictRet[3]
    
    retriedTimes = int(PORTS_BIT_ERROR_SPEC / PORTS_BIT_ERROR_INTERVAL)
    for i in range(0, retriedTimes):
        time.sleep(PORTS_BIT_ERROR_INTERVAL)
        nextResultDictRet = getPortsBitErrorResultDict(cli, cmd, ports, lang)
        nextCliRet = nextResultDictRet[1]
        cliRetAll = firstCliRet + nextCliRet
        if nextResultDictRet[0] != True:
            return (nextResultDictRet[0], cliRetAll, nextResultDictRet[2])
        nextResultDict = nextResultDictRet[3]
        
        for portName in ports:
            firstBitErrorList = firstResultDict.get(portName)
            nextbitErrorList = nextResultDict.get(portName)
            
            if len(firstBitErrorList) != len(nextbitErrorList):
                continue
            
            cmpResult = cmpDictList(firstBitErrorList, nextbitErrorList)
            if cmpResult == -1:
                flag = False
                errMsg += getMsg(lang, "port.exists.error.bits", portName)
        
        if not flag:
            return (False, cliRetAll, errMsg)
            
    return (True, cliRetAll, "")
        
def getPortsBitErrorResultDict(cli, cmd, ports, lang):
    '''
    @summary: 获取指定端口列表对应的误码列表
    @param cli: cli对象
    @param cmd: cli命令
    @param ports: 端口列表
    @param lang: 语言对象
    @return: 
        flag: 
            True: 获取成功
            False: 获取失败
        cliRet: cli回显
        errMsg: 错误时的消息
        resultDict: 以字典的形式返回对应端口的误码列表。键对应端口，值对应该端口的误码列表
    '''
    resultDict = {}
    
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if checkRet[0] != True:
        return (checkRet[0], cliRet, checkRet[2], None)
    
    for portName in ports:
        getBitErrorResultListRet = getPortBitErrorResultList(cliRet, portName, lang)
        if getBitErrorResultListRet[0] != True:
            return (getBitErrorResultListRet[0], cliRet, getBitErrorResultListRet[2], None)
        
        resultDict.setdefault(portName, getBitErrorResultListRet[1])
    return (True, cliRet, "", resultDict)

def getPortBitErrorResultList(cliRet, portName, lang):
    '''
    @summary: 获取每个端口的误码列表
    @param cliRet: cli回显
    @param portName: 端口名
    @param lang: 语言对象
    @return: 
        flag: 
            True: 获取成功
            False: 获取失败
        resultList: 误码列表
        errMsg: 错误时的消息
    '''
    portInfoRet = cliUtil.getSplitedCliRet(cliRet, getSplitedPortWords(portName))
    if len(portInfoRet) == 0:
        return (True, [], "")
        
    cliRetLinesList = cliUtil.getHorizontalCliRet(portInfoRet)
    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.port.info", portName)
        return (False, None, errMsg)
    
    return (True, cliRetLinesList, "")
    
def cmpDictList(firstList, secondList):
    '''
    @summary: 判断误码数是否有增加
    @param firstList: 第一个列表（列表中的内容为字典）
    @param secondList: 第二个列表（列表中的内容为字典，且字典的键与第一个列表中字典的键一致，同时第二个列表的长度与第一个列表的长度一致）
    @return: 
        -1: 第一个列表中的元素小于第二个列表中的元素
         0: 第一个列表与第二个列表相等
         1: 第一个列表中的元素大于第二个列表中的元素
    '''
    for i in range(0, len(firstList)):
        firstDict = firstList[i]
        secondDict = secondList[i]
        
        for key in firstDict.keys():
            firstValue = unicode(firstDict.get(key))
            secondValue = unicode(secondDict.get(key))
            
            if firstValue.isdigit() and secondValue.isdigit():
                ret = cmp(long(firstValue), long(secondValue))
                if ret != 0:
                    return ret
    return 0

def getSplitedPortWords(portName):
    '''
    @summary: 根据端口名获取对应的分割字
    @param portName: 端口名
    @return: 分割字
    '''
    if portName == "PCIe":
        portName = "PCIE" 
    return portName + " port:"

def downloadErrCodeFile():
    '''
    @summary: 使用SFTP功能将错误码文件下载到本地
    '''
    return

def getErrCodeInfoDict(lang, fileName="event_xve"):
    '''
    @summary: 获取对应语言的错误码信息，将错误码信息转换为以错误码ID为key，以含错误码详细信息和修复建议的字典为value的字典
    @param lang: 语言对象
    @param fileName: 错误码文件默认为error_{zh|en}.xml
    '''
    try:
        #1.下载错误码文件到本地
        downloadErrCodeFile()
        #2.获取xml中根节点对象
        root = ElementTree.parse(os.path.join(os.path.abspath(
            os.path.join(os.path.dirname(__file__), "..")), "res", "%s_%s.xml" % (fileName, lang)))
        #3.找到error子节点
        errorNodes = root.findall("eventDefinition/param")

        errCodeInfoDict = {}
        for errorNode in errorNodes:
            #4.获取错误码ID
            eventId = errorNode.attrib.get("eventID","")
            #5.获取错误码修复建议
            suggesions = errorNode.attrib.get("suggestion","")
            #6.获取误码对象名称
            objName = errorNode.attrib.get("objName","")
            errCodeInfoDict[eventId] = {"objName":objName, "suggesions":suggesions}
        
        return errCodeInfoDict
    except Exception, exp:
        #解析失败时，使用默认的修复建议策略
        return {}

def getErrSuggestions(lang, errCodeInfoDict, errId):
    '''
    @summary: 获取单条错误码对应的修复建议
    @param lang: 语言对象
    @param errCodeInfoDict: 错误码信息字典
    @param errId: 错误码ID
    '''
    
    suggestions = ""
    
    errCodeInfo = errCodeInfoDict.get(errId, {})
    suggestions += errCodeInfo.get("suggesions", "")

    return suggestions

def getSuggestions(lang, errCodeInfoDict, alarmIds, des=None):
    '''
    @summary: 获取多条错误码对应的修复建议
    @param lang: 语言对象
    @param errCodeInfoDict: 错误码信息字典
    @param errIds: 错误码ID列表
    '''
    sugs =  "\n".join([getErrSuggestions(lang, errCodeInfoDict, alarmId) for alarmId in alarmIds])
    
    if des is None:
        return sugs
    else:
        return des + "\n" + sugs

def getObjAlarmIds(lang, cli, obj):
    '''
    @summary: 根据指定对象查询该对象下的告警ID列表
    @param lang: 语言对象
    @param cli: cli对象
    @param obj: 指定对象
    '''
    alarmIds = set()
    cmd = "show alarm object_type=%s"  % (obj)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    
    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        alarmId = line["ID"]
        alarmId = unicode(int(alarmId, 16))
        
        alarmIds.add(alarmId)

    return alarmIds

def getSuggestionResults(lang, errCodeInfoDict, cli, obj, des=None):
    '''
    @summary: 根据指定对象，返回该指定对象下的所有错误码修复建议
    @param lang: 语言对象
    @param errCodeInfoDict: 错误码信息字典
    @param cli: cli对象
    @param obj: 指定对象
    '''
    try:
        alarmIds = getObjAlarmIds(lang, cli, obj)
        result = getSuggestions(lang, errCodeInfoDict, alarmIds, des)
        
        return result
    except:
        return ""
def isSigleModel(cli, lang):
    '''
          控制器模式检查：
                  执行show system config_model命令，查看返回结果：Configuration Model为Multi-Controller时多多控，为Single-Controller时为单控
    '''
    cliRet = ""
    errMsg = ""
    cmd = "show system config_model"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if "single" in cliRet.lower():
        return True
    else:
        return False
    
def getHotPatchVersion(context):
    '''
    @summary: 热补丁版本号
    @param context: 上下文对象
    @return: 检查是否成功，补丁版本号，cli回显，errMsg
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""
    hotPatchVersion = ""
    cmd = "show upgrade package"
    LOGGER.logExecCmd(cmd)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] != True:
        LOGGER.logSysAbnormal()
        return (checkRet[0], hotPatchVersion, checkRet[1], checkRet[2])
    
    cliRet = checkRet[1]
    beginIndex = cliRet.find('HotPatch Version')
    if beginIndex == -1:
        LOGGER.logSysAbnormal()
        return (False, hotPatchVersion, checkRet[1], checkRet[2])
    cliRetDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex:])
    hotPatchVersion = cliRetDictList[0].get('Current Version')
    return (True, hotPatchVersion, cliRet, errMsg)

def setProgress(context, progress, item):
    try:
        observer = context.get("progressObserver")
        if observer != None:
            observer.updateItemProgress(context.get("dev"), int(progress), item)
    except (JException, Exception), exption:
        pass


def updateProcess(context, item):
    # 剩余时间总数
    totalTime = 10
    oneProgress = 80
    totalReaminTime = totalTime


    secondTotleTime = 20
    secondProgress = 99
    secondReaminTime = secondTotleTime

    UPGRADE_PROCESS_INTEVAL_TIME = 1
    currentPro = 0

    setProgress(context, currentPro, item)

    while context["checkState"] == PROCESS_STATE_CHECKING:
        # 更新进度条
        if totalReaminTime > 0:
            totalReaminTime -= UPGRADE_PROCESS_INTEVAL_TIME
            currentPro = int(oneProgress * (totalTime - totalReaminTime) / totalTime)

        if totalReaminTime <= 0:
            secondTotleTime -= UPGRADE_PROCESS_INTEVAL_TIME
            if secondTotleTime <= 0:
                setProgress(context, secondProgress, item)
                continue

            currentPro = int(oneProgress + (secondProgress-oneProgress) * (secondTotleTime - secondReaminTime) / secondTotleTime)
        setProgress(context, currentPro, item)
        safeSleep(UPGRADE_PROCESS_INTEVAL_TIME)

    setProgress(context, secondProgress+1, item)
    return


def safeSleep(seconds):
    '''
    @summary: 安全睡眠时间
    @param param: seconds为睡眠时间，单位：秒；数据类型：整数或小数
    '''
    try:
        if type(seconds) not in [int, long, float] or seconds <= 0:
            return

        startTime = time.clock()
        while True:
            if (time.clock() - startTime) >= seconds:
                return

            # 睡眠一下，避免长时间占用cpu，该时间设置过长会影响睡眠时间精度
            try:
                time.sleep(0.1)
            except:
                pass
    except:
        return


def threadUp(context, item, totalTime=10, secondTotleTime=20):
    try:
        t = threading.Thread(target=updateProcess, args=(context, item, totalTime, secondTotleTime))
        t.start()
        context["thread"] = t
    except:
        pass


def threadJoin(context):
    try:
        if context.get("thread") != None:
            context["thread"].join()
    except:
        pass


def finishProcess(context, item):
    context["checkState"] = PROCESS_UPGRADE_FINISHED
    threadJoin(context)
    setProgress(context, PROGRESS_NUM_MAX, item)
    return
