# -*- coding: UTF-8 -*-

MESSAGES_DICT = {
"user.login.failure":
    {
        "zh":u"\n当前登陆用户不为admin，请使用admin用户重新登陆",
        "en":"\nThe current user is not admin. Please log in as user admin",
    },
"check.pass":
    {
        "zh":u"\n系统检查通过",
        "en":"\nSystem check pass",
    },

"query.result.abnormal":
    {
        "zh":u"\n获取信息失败",
        "en":"\nThere is an error in getting information",
    },
                 
"get.result.abnormal":
    {
        "zh":u"\n查询结果异常。",
        "en":"\nQuery result is abnormal.",
    },

"cannot.get.system.info":
    {
        "zh":u"\n无法获取系统信息",
        "en":"\nCannot get information about system",
    },

"cannot.get.product.version.info":
    {
        "zh":u"\n无法获取产品版本信息",
        "en":"\nCannot get information about product version",
    },

"cannot.get.controller.info":
    {
        "zh":u"\n无法获取控制器信息",
        "en":"\nCannot get information about controller",
    },

"cannot.get.enclosure.info":
    {
        "zh":u"\n无法获取机框信息",
        "en":"\nCannot get information about enclosure",
    },

"cannot.get.bbu.info":
    {
        "zh":u"\n无法获取BBU信息",
        "en":"\nCannot get information about BBU",
    },

"cannot.get.bbu.config":
    {
        "zh":u"\n无法获取BBU规格",
        "en":"\nCannot get information about BBU specification",
    },

"cannot.get.remaining.lifetime.info":
    {
        "zh":u"\n无法获取BBU的生命剩余时间信息",
        "en":"\nCannot get information about lifespan of BBU",
    },

"cannot.get.bbu.remaining.lifetime":
    {
        "zh":u"\n无法获取BBU[%s]的生命剩余时间信息",
        "en":"\nCannot get information about lifespan of BBU [%s]",
    },

"cannot.get.fan.info":
    {
        "zh":u"\n无法获取风扇信息",
        "en":"\nCannot get information about fan",
    },

"cannot.get.fan.config":
    {
        "zh":u"\n无法获取风扇规格",
        "en":"\nCannot get information about fan specification",
    },

"cannot.get.power.supply.info":
    {
        "zh":u"\n无法获取电源信息",
        "en":"\nCannot get information about power supply",
    },

"cannot.get.fibre.module.info":
    {
        "zh":u"\n无法获取光模块信息",
        "en":"\nCannot get information about optical module",
    },

"cannot.get.pcie.switch.info":
    {
        "zh":u"\n无法获取PCIe交换机信息",
        "en":"\nCannot get information about PCIe switch",
    },

"cannot.get.interface.module.info":
    {
        "zh":u"\n无法获取接口卡信息",
        "en":"\nCannot get information about interface module",
    },

"cannot.get.port.info":
    {
        "zh":u"\n无法获取%s端口信息",
        "en":"\nCannot get information about %s port",
    },

"cannot.get.port.working.rate":
    {
        "zh":u"\n无法获取%s端口[%s]速率",
        "en":"\nCannot get working rate of %s port [%s]",
    },

"cannot.get.management.port.info":
    {
        "zh":u"\n无法获取管理网口信息",
        "en":"\nCannot get information about management port",
    },
"ib.port.health.status.abnormal":
    {
        "zh":u"\nIB 端口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of ib port [%s] is abnormal (Health Status:%s)",
    },
"ib.port.bit.error.health.status.abnormal":
    {
        "zh":u"\nIB 端口[%s]健康状态异常(误码:%s, 值：%s)",
        "en":"\nThe health status of ib port [%s] is abnormal (Ib Port Bit Error:%s, Value:%s)",
    },

"cannot.get.routing.test.status.info":
    {
        "zh":u"\n无法获取硬盘例测状态信息",
        "en":"\nCannot get information about disk routine test status",
    },

"cannot.get.disk.precopy.info":
    {
        "zh":u"\n无法获取硬盘预拷贝开关信息",
        "en":"\nCannot get information about disk pre-copy switch",
    },

"cannot.get.bst.config.info":
    {
        "zh":u"\n无法获取BST开关信息",
        "en":"\nCannot get information about BST switch",
    },

"cannot.get.disk.health.info":
    {
        "zh":u"\n无法获取硬盘健康度信息",
        "en":"\nCannot get information about disk health",
    },

"cannot.get.disk.info":
    {
        "zh":u"\n无法获取磁盘状态信息",
        "en":"\nCannot get information about disk status",
    },

"cannot.get.front.end.io.info":
    {
        "zh":u"\n无法获取控制器[%s]的前端并发数信息",
        "en":"\nCannot get information about front-end concurrencies of controller [%s]",
    },

"cannot.get.back.end.io.info":
    {
        "zh":u"\n无法获取控制器[%s]后端并发数信息",
        "en":"\nCannot get information about back-end concurrencies of controller [%s]",
    },

"cannot.get.cpu.usage.info":
    {
        "zh":u"\n无法获取CPU占用率信息",
        "en":"\nCannot get information about CPU usage",
    },

"cannot.get.dirty.data.rate.info":
    {
        "zh":u"\n无法获取控制器[%s]的脏页面占用率信息",
        "en":"\nCannot get information about dirty data rate of controller [%s]",
    },

"cannot.get.used.hot.spare.capacity.info":
    {
        "zh":u"\n无法获取POOL[%s]的hotspare容量信息",
        "en":"\nCannot get information about hotspare capacity of POOL [%s]",
    },

"cannot.get.device.sn.info":
    {
        "zh":u"\n无法获取设备序列号信息",
        "en":"\nCannot get information about serial number of device",
    },

"cannot.get.multipathing.info":
    {
        "zh":u"\n无法获取硬盘链路状态信息",
        "en":"\nCannot get information about hard disk path",
    },

"cannot.get.link.info":
    {
        "zh":u"\n无法获取%s链路信息",
        "en":"\nCannot get information about %s link",
    },

"cannot.get.version.of.controller":
    {
        "zh":u"\n无法获取控制器版本信息",
        "en":"\nCannot get information about version of controllers",
    },

"cannot.get.software.version.of.controller":
    {
        "zh":u"\n无法获取控制器[%s]的软件版本信息",
        "en":"\nCannot get information about software version of controller [%s]",
    },

"cannot.get.bmc.version.of.controller":
    {
        "zh":u"\n无法获取控制器[%s]的BMC版本信息",
        "en":"\nCannot get information about BMC version of controller [%s]",
    },

"cannot.get.ses.version.of.controller":
    {
        "zh":u"\n无法获取控制器[%s]的SES版本信息",
        "en":"\nCannot get information about SES version of controller [%s]",
    },

"cannot.get.bios.version.of.controller":
    {
        "zh":u"\n无法获取控制器[%s]的BIOS版本信息",
        "en":"\nCannot get information about BIOS version of controller [%s]",
    },

"cannot.get.logic.version.of.controller":
    {
        "zh":u"\n无法获取控制器[%s]的Logic版本信息",
        "en":"\nCannot get information about logic version of controller [%s]",
    },

"cannot.get.ses.version.of.expansion.module":
    {
        "zh":u"\n无法获取级联模块[%s]的SES版本信息",
        "en":"\nCannot get information about SES version of expansion module [%s]",
    },

"cannot.get.logic.version.of.expansion.module":
    {
        "zh":u"\n无法获取级联模块[%s]的Logic版本信息",
        "en":"\nCannot get information about logic version of expansion module [%s]",
    },

"cannot.get.firmware.version.info":
    {
        "zh":u"\n无法获取BBU的Firmware版本信息",
        "en":"\nCannot get information about firmware version of BBU",
    },

"cannot.get.firmware.version.of.bbu":
    {
        "zh":u"\n无法获取BBU[%s]的Firmware版本信息",
        "en":"\nCannot get information about firmware version of BBU [%s]",
    },

"cannot.get.disk.domain.info":
    {
        "zh":u"\n无法获取硬盘域信息",
        "en":"\nCannot get information about disk domain",
    },

"cannot.get.filesystem.info":
    {
        "zh":u"\n无法获取文件系统信息",
        "en":"\nCannot get information about File System",
    },

"cannot.get.pool.info":
    {
        "zh":u"\n无法获取POOL信息",
        "en":"\nCannot get information about POOL",
    },

"cannot.get.tier.info":
    {
        "zh":u"\n无法获取Tier信息",
        "en":"\nCannot get information about tier",
    },

"cannot.get.lun.info":
    {
        "zh":u"\n无法获取LUN信息",
        "en":"\nCannot get information about LUN",
    },

"cannot.get.lun.copy.info":
    {
        "zh":u"\n无法获取LUN拷贝信息",
        "en":"\nCannot get information about LUN copy",
    },

"cannot.get.lun.migration.info":
    {
        "zh":u"\n无法获取LUN迁移信息",
        "en":"\nCannot get information about LUN migration",
    },

"cannot.get.lun.write.policy.info":
    {
        "zh":u"\n无法获取LUN写策略信息",
        "en":"\nCannot get information about LUN write policy",
    },

"cannot.get.lun.ownership.info":
    {
        "zh":u"\n无法获取LUN归属信息",
        "en":"\nCannto get information about LUN ownership",
    },

"cannot.get.relocatioin.status":
    {
        "zh":u"\n无法获取Extent迁移状态信息",
        "en":"\nCannot get information about extent migration status",
    },

"cannot.get.license.service.auth.info":
    {
        "zh":u"\n无法获取license信息",
        "en":"\nCannot get information about license",
    },

"cannot.get.smartcache.info":
    {
        "zh":u"\n无法获取Smart Cache信息",
        "en":"\nCannot get information about Smart Cache",
    },

"cannot.get.snapshot.info":
    {
        "zh":u"\n无法获取快照信息",
        "en":"\nCannot get information about snapshot",
    },

"cannot.get.clone.info":
    {
        "zh":u"\n无法获取克隆信息",
        "en":"\nCannot get information about clone",
    },

"cannot.get.remote.replication.info":
    {
        "zh":u"\n无法获取远程复制信息",
        "en":"\nCannot get information about remote replication",
    },

"cannot.get.consistency.group.info":
    {
        "zh":u"\n无法获取一致性组信息",
        "en":"\nCannot get information about consistency group",
    },

"cannot.get.remote.lun.info":
    {
        "zh":u"\n无法获取远端LUN信息",
        "en":"\nCannot get information about remote LUN",
    },

"cannot.get.mirror.lun.info":
    {
        "zh":u"\n无法获取镜像LUN信息",
        "en":"\nCannot get information about mirror LUN",
    },

"cannot.get.alarm.info":
    {
        "zh":u"\n无法获取告警信息",
        "en":"\nCannot get information about alarm",
    },

"system.health.status.abnormal":
    {
        "zh":u"\n系统健康状态异常(健康状态：%s)",
        "en":"\nThe health status of system is abnormal (Health Status:%s)",
    },

"system.running.status.abnormal":
    {
        "zh":u"\n系统运行状态异常(运行状态：%s)",
        "en":"\nThe running status of system is abnormal (Running Status:%s)",
    },

"controller.health.status.abnormal":
    {
        "zh":u"\n控制器[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of controller [%s] is abnormal (Health Status:%s)",
    },

"controller.running.status.abnormal":
    {
        "zh":u"\n控制器[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of controller [%s] is abnormal (Running Status:%s)",
    },

"controller.status.abnormal":
    {
        "zh":u"\n控制器[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of controller [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },

"enclosure.health.status.abnormal":
    {
        "zh":u"\n框[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of enclosure [%s] is abnormal (Health Status:%s)",
    },

"enclosure.running.status.abnormal":
    {
        "zh":u"\n框[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of enclosure [%s] is abnormal (Running Status:%s)",
    },

"enclosure.status.abnormal":
    {
        "zh":u"\n框[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of enclosure [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },

"power.supply.health.status.abnormal":
    {
        "zh":u"\n电源[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of power supply [%s] is abnormal (Health Status:%s)",
    },

"power.supply.running.status.abnormal":
    {
        "zh":u"\n电源[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of power supply [%s] is abnormal (Running Status:%s)",
    },

"power.supply.status.abnormal":
    {
        "zh":u"\n电源[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of power supply [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },

"bbu.health.status.abnormal":
    {
        "zh":u"\nBBU[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of BBU [%s] is abnormal (Health Status:%s)",
    },

"bbu.running.status.abnormal":
    {
        "zh":u"\nBBU[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of BBU [%s] is abnormal (Running Status:%s)",
    },

"bbu.status.abnormal":
    {
        "zh":u"\nBBU[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of BBU [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },

"fan.health.status.abnormal":
    {
        "zh":u"\n风扇[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of fan [%s] is abnormal (Health Status:%s)",
    },

"fan.running.status.abnormal":
    {
        "zh":u"\n风扇[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of fan [%s] is abnormal (Running Status:%s)",
    },
    
"fan.status.abnormal":
    {
        "zh":u"\n风扇[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of fan [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },

"auxiliary.fan.health.status.abnormal":
    {
        "zh":u"\n辅助散热风扇[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of auxiliary fan [%s] is abnormal (Health Status:%s)",
    },

"filesystem.health.status.abnormal":
    {
        "zh":u"\n文件系统[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of File System [%s] is abnormal (Health Status:%s)",
    },

"auxiliary.fan.running.status.abnormal":
    {
        "zh":u"\n辅助散热风扇[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of auxiliary fan [%s] is abnormal (Running Status:%s)",
    },

"disk.health.mark.abnormal":
    {
        "zh":u"\n硬盘[%s]健康状态异常(Health Mark：%s)",
        "en":"\nThe health mark of disk [%s] is abnormal (Health Mark:%s)",
    },

"disk.status.abnormal":
    {
        "zh":u"\n磁盘[%s]状态异常",
        "en":"\nThe status of disk [%s] is abnormal",
    },

"dataswitch.health.status.abnormal":
    {
        "zh":u"\n交换机[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of data switch [%s] is abnormal (Health Status:%s)",
    },

"dataswitch.running.status.abnormal":
    {
        "zh":u"\n交换机[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of data switch [%s] is abnormal (Running Status:%s)",
    },

"interface.module.health.status.abnormal":
    {
        "zh":u"\n接口卡[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of interface module [%s] is abnormal (Health Status:%s)",
    },

"interface.module.running.status.abnormal":
    {
        "zh":u"\n接口卡[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of interface module [%s] is abnormal (Running Status:%s)",
    },

"port.fibre.module.health.status.abnormal":
    {
        "zh":u"\n端口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of port [%s] is abnormal (Health Status:%s)",
    },

"port.health.status.abnormal":
    {
        "zh":u"\n%s端口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of %s port [%s] is abnormal (Health Status:%s)",
    },

"sas.port.running.status.abnormal":
    {
        "zh":u"\nSAS端口[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of SAS port [%s] is abnormal (Running Status:%s)",
    },

"management.port.health.status.abnormal":
    {
        "zh":u"\n管理网口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of management port [%s] is abnormal (Health Status:%s)",
    },

"disk.domain.health.status.abnormal":
    {
        "zh":u"\n硬盘域[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of disk domain [%s] is abnormal (Health Status:%s)",
    },

"disk.domain.running.status.abnormal":
    {
        "zh":u"\n硬盘域[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of disk domain [%s] is abnormal (Running Status:%s)",
    },

"pool.health.status.abnormal":
    {
        "zh":u"\nPOOL[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of POOL [%s] is abnormal (Health Status:%s)",
    },

"pool.running.status.abnormal":
    {
        "zh":u"\nPOOL[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of POOL [%s] is abnormal (Running Status:%s)",
    },

"pool.relocation.status.abnormal":
    {
        "zh":u"\nPOOL[%s]迁移状态异常(迁移状态：%s)",
        "en":"\nThe relocation status of POOL [%s] is abnormal (Relocation Status:%s)",
    },

"lun.status.abnormal":
    {
        "zh":u"\nLUN[%s]状态异常",
        "en":"\nThe status of LUN [%s] is abnormal",
    },

"lun.copy.health.status.abnormal":
    {
        "zh":u"\nLUN拷贝[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of LUN copy [%s] is abnormal (Health Status:%s)",
    },

"snapshot.health.status.abnormal":
    {
        "zh":u"\n快照[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of snapshot [%s] is abnormal (Health Status:%s)",
    },

"lun.migration.running.status.abnormal":
    {
        "zh":u"\nLUN迁移[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of LUN migration [%s] is abnormal (Running Status:%s)",
    },

"clone.health.status.abnormal":
    {
        "zh":u"\n克隆[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of clone [%s] is abnormal (Health Status:%s)",
    },

"remote.replication.health.status.abnormal":
    {
        "zh":u"\n远程复制[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of remote replication [%s] is abnormal (Health Status:%s)",
    },

"consistency.group.health.status.abnormal":
    {
        "zh":u"\n一致性组[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of consistency group [%s] is abnormal (Health Status:%s)",
    },

"mirror.lun.health.status.abnormal":
    {
        "zh":u"\n镜像LUN[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of mirror LUN [%s] is abnormal (Health Status:%s)",
    },

"port.working.rate.abnormal":
    {
        "zh":u"\n%s端口[%s]工作速率异常(速率：%sMbps)",
        "en":"\nThe working rate of %s port [%s] is abnormal (Working Rate:%sMbps)",
    },

"management.port.working.rate.abnormal":
    {
        "zh":u"\n管理网口[%s]工作速率异常(速率：%sMbps)",
        "en":"\nThe working rate of management port [%s] is abnormal (Working Rate:%sMbps)",
    },

"software.version.of.controller.inconsistent":
    {
        "zh":u"\n控制器软件版本不一致(%s)",
        "en":"\nThe software versions of all controllers are inconsistent (%s)",
    },

"version.of.controller.inconsistent":
    {
        "zh":u"\n控制器%s版本不一致(%s)",
        "en":"\nThe %s versions of all controllers are inconsistent (%s)",
    },

"version.of.expansion.module.on.disk.inconsistent":
    {
        "zh":u"\n硬盘框级联模块%s版本不一致(%s)",
        "en":"\nThe %s versions of all expansion modules in disk enclosures are inconsistent (%s)",
    },

"version.of.expansion.module.on.high-density.inconsistent":
    {
        "zh":u"\n高密框级联模块%s版本不一致(%s)",
        "en":"\nThe %s versions of all expansion modules in high-density disk enclosures are inconsistent (%s)",
    },

"firmware.version.of.bbu.inconsistent":
    {
        "zh":u"\nBBU的Firmware版本不一致(%s)",
        "en":"\nThe firmware versions of all BBUs are inconsistent (%s)",
    },

"engine.may.be.offline":
    {
        "zh":u"\n引擎[%s]存在无法监控的控制器",
        "en":"\nEngine [%s] has controllers that cannot be monitored.",
    },

"fan.number.not.enough":
    {
        "zh":u"\n框[%s]存在风扇个数不足(满配个数：%s，实际个数：%s)",
        "en":"\nThe number of fans in the enclosure [%s] is insufficient (Required Number:%s, Current Number:%s)",
    },

"bbu.number.not.enough":
    {
        "zh":u"\n引擎[%s]存在BBU个数不足(满配个数：%s，实际个数：%s)",
        "en":"\nThe number of BBUs in the engine [%s] is insufficient (Required Number:%s, Current Number:%s)",
    },

"bbu.remaining.lifetime.abnormal":
    {
        "zh":u"\nBBU[%s]的生命剩余时间小于%s天(生命剩余时间：%s天)",
        "en":"\nThe remaining lifetime of BBU [%s] is less than [%s] days (Remaining Lifetime:%sdays)",
    },

"pcie.switch.number.not.enough":
    {
        "zh":u"\nPCIe交换机个数不足",
        "en":"\nThe number of PCIe switches is insufficient",
    },

"disk.path.single":
    {
        "zh":u"\n硬盘[%s]单链路",
        "en":"\nThe path of disk [%s] is single",
    },

"sas.port.link.none.symmetrical":
    {
        "zh":u"\nSAS端口[%s]连接异常，与端口[%s]连接不对称",
        "en":"\nThe SAS port [%s] is improperly connected and is not symmetrical with port [%s]",
    },

"raid.level.improperly.config":
    {
        "zh":u"\nRAID级别配置不正确(POOL ID：%s, Name：%s, RAID级别：%s)",
        "en":"\nThe RAID level is improperly configured (POOL ID:%s, Name:%s, RAID Level:%s)",
    },

"engine.zero.circle.not.connected":
    {
        "zh":u"\n引擎环路0未连接",
        "en":"\nLoop 0 of the engine is not connected",
    },

"engine.zero.circle.connect.abnormal":
    {
        "zh":u"\n引擎环路0必须连接，SAS端口[%s]未连接",
        "en":"\nLoop 0 of the engine must be connected. The SAS port [%s] is disconnected",
    },

"port.exists.error.bits":
    {
        "zh":u"\n%s端口存在持续增加的误码",
        "en":"\nThe %s port has continuous bit errors",
    },

"controller.cpu.usage.abnormal":
    {
        "zh":u"\n控制器[%s]CPU占用率超过%s(CPU占用率：%s)",
        "en":"\nThe CPU usage of controller [%s] exceeds %s (CPU usage:%s)",
    },

"pool.used.hot.spare.capacity.abnormal":
    {
        "zh":u"\nPOOL[%s]的已使用Hotspare容量大于0(容量:%s)",
        "en":"\nThe used hot spare capacity of POOL [%s] is more than 0 (Capacity:%s)",
    },

"disk.precopy.status.abnormal":
    {
        "zh":u"\n硬盘预拷贝开关异常(预拷贝开关：%s)",
        "en":"\nThe pre-copy enabled switch of disk is abnormal (Precopy Enabled:%s)",
    },

"disk.bst.status.abnormal":
    {
        "zh":u"\n硬盘BST开关状态异常(BST开关：%s)",
        "en":"\nThe BST enabled status of disk is abnormal (Enabled:%s)",
    },

"disk.routine.test.switch.abnormal":
    {
        "zh":u"\n硬盘例测开关异常(例测开关：%s)",
        "en":"\nThe routine test switch of disk is abnormal (Enable Routine Test:%s)",
    },

"disk.routine.test.period.abnormal":
    {
        "zh":u"\n硬盘例测周期异常(例测周期：%sMinute)",
        "en":"\nThe routine test period of disk is abnormal (Routine Test Period:%sMinute)",
    },
"device.sn.incorrect":
    {
        "zh":u"\n设备序列号不正确",
        "en":"\nThe serial number information of device is incorrect",
    },

"system.exists.temporary.license":
    {
        "zh":u"\n存在临时license",
        "en":"\nLICENSE SERVICE AUTH TYPE is DEMO, a temporary license exists",
    },
"lun.controller.owner.invalid":
    {
        "zh":u"\nLUN[%s]的工作控制器或归属控制器不合法",
        "en":"\nThe work controller or owner controller of LUN [%s] is invalid",
    },

"lun.controller.owner.inconsistent":
    {
        "zh":u"\nLUN[%s]的工作控制器与归属控制器不一致",
        "en":"\nThe work controller of the LUN [%s] is inconsistent with the owner controller",
    },

"lun.write.policy.inconsistent":
    {
        "zh":u"\nLUN[%s]的写策略与当前缓存写策略不一致",
        "en":"\nThe write policy of LUN [%s] is not consistent with running write policy",
    },

"smartcache.partion.abnormal":
    {
        "zh":u"\n默认分区个数与正常引擎个数不相同(默认分区个数：%s，正常引擎个数：%s)",
        "en":"\nThe number of default partition is not identical with the number of normal engines (Number of default partition:%s, Number of normal engines:%s)",
    },

"remote.lun.status.abnormal":
    {
        "zh":u"\n远端LUN状态异常",
        "en":"\nThe status of remote LUN is abnormal",
    },

"remote.lun.path.status.abnormal":
    {
        "zh":u"\n远端LUN路径状态异常",
        "en":"\nThe path status of remote LUN is abnormal",
    },

"remote.lun.status.single":
    {
        "zh":u"\n远端LUN链路状态为单链路",
        "en":"\nThe link status of remote LUN is single",
    },

"host.multipathing.status.abnormal":
    {
        "zh":u"\n主机多路径状态异常(告警ID:%s)",
        "en":"\nThe host multipathing status is abnormal (alarm id:%s)",
    },

"system.exists.critical.alarm":
    {
        "zh":u"\n系统存在紧急告警",
        "en":"\nSystem exists critical alarm",
    },

"system.exists.major.alarm":
    {
        "zh":u"\n系统存在重要告警",
        "en":"\nSystem exists major alarm",
    },

"system.exists.warning.alarm":
    {
        "zh":u"\n系统存在警告告警",
        "en":"\nSystem exists warning alarm",
    },

    
"cannot.get.vm.file.system.info":
    {
        "zh":u"\n无法获取虚拟机文件系统",
        "en":"\nCannot get information about VM file system",
    },
    
"port.vm.file.system.current.status.abnormal":
    {
        "zh":u"\n虚拟机文件系统[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of VM file system [%s] is abnormal (Health Status:%s)",
    },
    
"cannot.get.block.device.info":
    {
        "zh":u"\n没有查询到虚拟机块设备",
        "en":"\nNo VM block device has been queried",
    },
    
"port.block.device.health.status.abnormal":
    {
        "zh":u"\n虚拟机块设备[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of VM block device [%s] is abnormal (Health Status:%s)",
    },
    
"cannot.get.vm.info":
    {
        "zh":u"\n没有查询到虚拟机",
        "en":"\nNo VM has been queried",
    },
    
"port.vm.health.status.abnormal":
    {
        "zh":u"\n虚拟机[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of VM [%s] is abnormal (Health Status:%s)",
    },
    
"cannot.get.configured.vm.info":
    {
        "zh":u"\n没有查询到被配置的虚拟机端口",
        "en":"\nNo configured VM port has been queried",
    },
    
"port.configured.vm.health.status.abnormal":
    {
        "zh":u"\n虚拟机端口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of configured VM port [%s] is abnormal (Health Status:%s)",
    },
   
"port.system.disk.bus.mode.abnormal":
    {
        "zh":u"\n虚拟机的System Disk Bus Mode不为VIRTIO(虚拟机名：%s，System Disk Bus Mode：%s)",
        "en":"\nThe system disk bus mode of VM is not VIRTIO (VM name:%s, System Disk Bus Mode:%s)",
    },
     
"port.vmtool.version.abnormal":
    {
        "zh":u"\n虚拟机的VMtool Version不是有效值(虚拟机名：%s，VMtool Version：%s)",
        "en":"\nThe VMtool Version of VM is not valid (VM name:%s, VMtool Version:%s)",
    },
"cannot.get.hypervault.info":
    {
        "zh":u"\n无法获取一体化备份信息",
        "en":"\nCannot get information about HyperVault.",
    },
"hypervault.health.status.abnormal":
    {
        "zh":u"\n一体化备份[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of HyperVault [%s] is abnormal (Health Status:%s)",
    },
"cannot.get.quorum.server.link.info":
    {
        "zh":u"\n无法获取双活仲裁链路状态信息",
        "en":"\nFailed to obtain the status of active-active quorum links.",
    },
"quorum.server.link.status.abnormal":
    {
        "zh":u"\n双活仲裁服务器[%s]链路状态异常(链路状态：%s)",
        "en":"\nThe status of the links to active-active quorum server [%s] is abnormal (link status: %s).",
    },
"cannot.get.cquorum.server.info":
    {
        "zh":u"\n无法获取双活仲裁服务器运行状态信息",
        "en":"\nFailed to obtain the running status of the active-active quorum server.",
    },
"quorum.server.running.status.abnormal":
    {
        "zh":u"\n双活仲裁服务器[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active quorum server [%s] is abnormal (running status: %s).",
    },
"cannot.get.hyper.metro.domain.info":
    {
        "zh":u"\n无法获取双活域运行状态信息",
        "en":"\nFailed to obtain the running status of the active-active domain.",
    },
"hyper.metro.domain.running.status.abnormal":
    {
        "zh":u"\n双活域[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active domain [%s] is abnormal (running status: %s).",
    },
"cannot.get.hyper.metro.pair.info":
    {
        "zh":u"\n无法获取双活Pair状态信息",
        "en":"\nFailed to obtain the status of the active-active pair.",
    },
"hyper.metro.pair.health.status.abnormal":
    {
        "zh":u"\n双活Pair[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of active-active pair [%s] is abnormal (health status: %s).",
    },
"hyper.metro.pair.link.status.abnormal":
    {
        "zh":u"\n双活Pair[%s]链路状态异常(链路状态：%s)",
        "en":"\nThe link status of active-active pair [%s] is abnormal (link status: %s).",
    },
"hyper.metro.pair.running.status.abnormal":
    {
        "zh":u"\n双活Pair[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active pair [%s] is abnormal (running status: %s).",
    },
"res.hyper.pair.status":
    {
        "zh":u"\n如果双活Pair的健康状态不为Normal或者链路状态不为Link Up或者运行状态不为Normal/Synchronizing/Pause/Force Started中的一种：",
        "en":"\nIf the health status of the active-active pair is not Normal, the link status is not Link Up, or the running status is not Normal, Synchronizing, Pause, or Force Started:",
    },
"res.hyper.domain.status":
    {
        "zh":u"\n如果双活域的运行状态不为Normal：",
        "en":"\nIf the running status of the HyperMetro domain is not Normal:",
    },
"res.quorum.server.status":
    {
        "zh":u"\n如果双活仲裁服务器运行状态不为Online：",
        "en":"\nIf the running status of the active-active quorum server is not Online:",
    },
"res.quorum.server.link.status":
    {
        "zh":u"\n如果双活仲裁服务器链路状态不为Normal：",
        "en":"\nIf the link status to the active-active quorum server is not Normal:",
    },
    
"check.result.abnormal":
    {
        "zh":u"\n控制器[%s]:检查结果异常",
        "en":"\nExecution abnormal of controller [%s]",
    },
    
"check.result.timeout":
    {
        "zh":u"\n控制器[%s]:检查结果超时",
        "en":"\nExecution timed out of controller [%s]",
    },
    
"check.reserved.memory.notpass":
    {
        "zh":u"\n控制器[%s]:系统预留内存空间不足：",
        "en":"\nThe reserved memory of controller [%s] is insufficient.",
    },
    
"check.reserved.memory.pass":
    {
        "zh":u"\n控制器[%s]:系统预留内存空间充足：",
        "en":"\nThe reserved memory of controller [%s] is enough. The upgrade can be performed.",
    },

"check.syssoftware.compatible.notpass":
    {
        "zh":u"\n控制器[%s]:系统软件不兼容",
        "en":"\nSystem software of controller [%s] is imcompatible",
    },
    
"check.syssoftware.compatible.pass":
    {
        "zh":u"\n控制器[%s]:系统版本兼容",
        "en":"\nSystem software of controller [%s] is compatible",
    },

"check.fwversion.compatible.pass":
    {
        "zh":u"\n控制器[%s]:固件版本兼容",
        "en":"\nThe firmware version of controller [%s] is compatible",
    },
    
"check.fwversion.compatible.notpass":
    {
        "zh":u"\n控制器[%s]:固件版本不兼容",
        "en":"\nThe firmware version of controller [%s] is imcompatible",
    },

"check.system.status.notpass":
    {
        "zh":u"\n系统状态异常",
        "en":"\nCannot perform the upgrade because the system is abnormal",
    },
    
"check.system.status.pass":
    {
        "zh":u"\n系统状态正常",
        "en":"\nThe system is normal",
    },

"check.system.resource.notpass":
    {
        "zh":u"\n控制器[%s]:系统CPU利用率或者内存空间不足",
        "en":"\nCannot perform the upgrade because system resources (CPU or Memory) of controller [%s] are insufficient",
    },
    
"check.system.resource.pass":
    {
        "zh":u"\n控制器[%s]:系统资源充足",
        "en":"\nSystem resources of controller [%s] meet the upgrade requirements",
    },
    
"check.system.pressure.notpass":
    {
        "zh":u"\n系统负载过大",
        "en":"\nThe current system operation load is heavy.",
    },
"check.system.pressure.pass":
    {
        "zh":u"\n系统负载正常",
        "en":"\nThe system operation load check is passed.",
    },

"check.version.consistance.notpass":
    {
        "zh":u"\n控制器间系统版本不一致",
        "en":"\nController versions are inconsistent.",
    },
    
"check.version.consistance.pass":
    {
        "zh":u"\n所有控制器系统版本一致",
        "en":"\nAll controller versions are consistent.",
    },
    
"check.double.controller.notpass":
    {
        "zh":u"\n控制器[%s]:为单控状态",
        "en":"\n[%s] is single controller.",
    },
    
"check.double.controller.pass":
    {
        "zh":u"\n控制器[%s]所在引擎的pair对为双控",
        "en":"\nThe engine of controller [%s] lies in has dual controllers.",
    },
    
"check.xnet.pressure.notpass":
    {
        "zh":u"\n控制器[%s]:Xnet压力过大",
        "en":"\nThe xnet service of controller [%s] is busy.",
    },
    
"check.xnet.pressure.pass":
    {
        "zh":u"\n控制器[%s]:Xnet压力正常",
        "en":"\nThe xnet pressure of controller [%s] check is passed.",
    },

"check.system_config.log.notpass":
    {
        "zh":u"\n系统配置日志没有结束",
        "en":"\nSystem configurations are not completed.",
    },
    
"check.system_config.log.pass":
    {
        "zh":u"\n系统配置日志检查通过",
        "en":"\nPass.",
    },
    
"check.front.pressure.notpass":
    {
        "zh":u"\n控制器[%s]:前端压力过大",
        "en":"\nFront-end pressure of controller [%s] does not meet the requirements.",
    },
    
"check.front.pressure.pass":
    {
        "zh":u"\n控制器[%s]:前端压力检查通过",
        "en":"\nFront-end pressure of controller [%s] meets the upgrade requirements.",
    },

"check.system.alarm.notpass":
    {
        "zh":u"\n系统存在紧急或重要告警",
        "en":"\nCritical or major alarms exist",
    },
    
"check.system.alarm.pass":
    {
        "zh":u"\n系统不存在紧急或者重要告警",
        "en":"\nNo alarms of the critical or major severity exist",
    },

"check.disk.usage.notpass":
    {
        "zh":u"\n控制器[%s]:磁盘利用率过高",
        "en":"\nCannot perform the upgrade because the disk usage of controller [%s] is high.",
    },
    
"check.disk.usage.pass":
    {
        "zh":u"\n控制器[%s]:磁盘利用率检查通过",
        "en":"\nThe disk usage of controller [%s] is normal",
    },

"check.disk.slow.notpass":
    {
        "zh":u"\n系统存在慢盘",
        "en":"\nSlow disks are found and an upgrade cannot be performed.",
    },
"check.disk.slow.pass":
    {
        "zh":u"\n系统无慢盘",
        "en":"\nNo slow disks are found and an upgrade can be performed.",
    },
"check.diskdomain.status.notpass":
    {
        "zh":u"\n控制器[%s]:硬盘域状态不正常",
        "en":"\nController[%s]:The status of disk domain is abnormal.",
    },
"check.diskdomain.status.pass":
    {
        "zh":u"\n控制器[%s]:硬盘域状态正常",
        "en":"\nController[%s]:The status of disk domain is normal and an upgrade can be performed.",
    },
"check.extlunlink.status.notpass":
    {
        "zh":u"\n外部Lun链路状态异常",
        "en":"\nExtern lun is single link.",
    },
"check.extlunlink.status.pass":
    {
        "zh":u"\n外部Lun链路状态正常",
        "en":"\nExtern lun link is normal and an upgrade can be performed.",
    },
"check.lun.destroy.pass":
    {
        "zh":u"\nLun销毁检查通过",
        "en":"\nCheck lun destroy pass.",
    },
"check.lun.destroy.notpass":
    {
        "zh":u"\nLun销毁状态异常",
        "en":"\nCheck lun destroy notpass.",
    },  
"check.disk.singlelink.notpass":
    {
        "zh":u"\n控制器[%s]:磁盘单链路检查不通过，不允许在线升级",
        "en":"\nDisk single link of controller [%s] check not pass, online upgrade can not be performed.",
    },
"check.disk.singlelink.pass":
    {
        "zh":u"\n控制器[%s]:磁盘单链路检查通过",
        "en":"\nThe disk single link of controller [%s] check pass.",
    },
"check.disk.isDiskInDiagnose.notpass":
    {
        "zh":u"\n控制器[%s]:有硬盘在线诊断,不允许升级",
        "en":"\nCannot perform the upgrade because disks of controller [%s] are being diagnosed online.",
    },
"check.disk.isDiskInDiagnose.pass":
    {
        "zh":u"\n控制器[%s]:没有硬盘在线诊断",
        "en":"\nNo disks of controller [%s] are being diagnosed online.",
    },
"check.hardware.BBUPower.notpass":
    {
        "zh":u"\n控制器[%s]:BBU电量不足",
        "en":"\nThe BBU of controller [%s] has insufficient amount of electricity.",
    },
"check.hardware.BBUPower.pass":
    {
        "zh":u"\n控制器[%s]:BBU电量充足",
        "en":"\nThe BBU of controller [%s] has sufficient amount of electricity.",
    },
"check.hardware.PCIESingleLink.notpass":
    {
        "zh":u"\n链路异常，不允许升级",
        "en":"\nThe link is abnormal. The upgrade cannot be performed.",
    },
"check.hardware.PCIESingleLink.pass":
    {
        "zh":u"\n链路正常，允许升级",
        "en":"\nThe link is normal. The upgrade can be performed.",
    },
"SingleLinkEnclosureCheck.notpass":
    {
        "zh":u"\n存在硬盘框单链路告警",
        "en":"\nAn alarm is generated indicating an expansion module fault.",
    },
"SingleLinkEnclosureCheck.pass":
    {
        "zh":u"\n硬盘框单链路检查通过",
        "en":"\nThe disk enclosure single link check is passed.",
    },
"InterfaceCardBreakdownCheck.notpass":
    {
        "zh":u"\n存在接口模块故障告警",
        "en":"\nAn alarm is generated indicating an interface module fault.",
    },
"InterfaceCardBreakdownCheck.pass":
    {
        "zh":u"\n接口卡故障检查通过",
        "en":"\nThe interface module check is passed.",
    },
"CascadedBoardBreakdownCheck.notpass":
    {
        "zh":u"\n存在级联模块故障告警",
        "en":"\nAn alarm is generated indicating an expansion module fault.",
    },
"CascadedBoardBreakdownCheck.pass":
    {
        "zh":u"\n级联模块故障检查通过",
        "en":"\nThe expansion module check is passed.",
    },
"ControllerBreakdownCheck.notpass":
    {
        "zh":u"\n存在控制器故障告警",
        "en":"\nAn alarm is generated indicating a controller fault.",
    },
"ControllerBreakdownCheck.pass":
    {
        "zh":u"\n控制器故障检查通过",
        "en":"\nThe controller check is passed.",
    },
"DiskDomainPossessionCheck.notpass":
    {
        "zh":u"\n硬盘域保有量设置过小，检查不通过，不支持升级",
        "en":"\nCan not perform upgrade because disk domain possession is set too small and the check is not passed.",
    },
"DiskDomainPossessionCheck.pass":
    {
        "zh":u"\n硬盘域保有量检查通过，可以进行升级操作。",
        "en":"\nDisk domain possession check is passed and upgrade can be performed.",
    },
"LUNPossessionCheck.notpass":
    {
        "zh":u"\nLUN保有量设置过小，检查不通过，不支持升级",
        "en":"\nCan not perform upgrade because LUN possession is set too small and the check is not passed.",
    },
"LUNPossessionCheck.pass":
    {
        "zh":u"\nLUN保有量检查通过，可以进行升级操作。",
        "en":"\nLUN possession check is passed and upgrade can be performed.",
    },
"check.vm.machine.shutdown.notpass":
    {
        "zh":u"\n当前控制器上有虚拟机处于未关闭状态，请关闭后再重试。",
        "en":"\nSome virtual machine is not shut off. Make sure all virtual machine is shut off and retry.",
    },
"check.vm.machine.shutdown.pass":
    {
        "zh":u"\n所有虚拟机是否关闭检测通过。",
        "en":"\nWhether all virtual machine shut off check is passed.",
    },  
"check.eth.port.ip.notpass":
    {
        "zh":u"\n主机端口IP配置存在升级兼容性隐患，请联系技术支持工程师协助处理。",
        "en":"\nCompatibility issues may occur during the IP address configuration of host ports. contact technical support engineers for help. ",
    },
"check.eth.port.ip.pass":
    {
        "zh":u"\n主机端口IP配置检查通过。",
        "en":"\nThe IP address configuration of host ports passes the check.",
    }, 
"check.protocol.notpass":
    {
        "zh":u"\n检查到有不支持在线升级的NAS协议（FTP、SMB1、SMB2、NFSV4和未开启CA开关的SMB3协议不支持在线升级）业务连接系统，请知会客户停相关业务后选择重试检查继续升级。如有任何疑问，请联系技术支持工程师协助处理。",
        "en":"\nThe check detects that there are NAS clients connecting to the system. If you have any questions, contact technical support engineers for help.",
    },
"check.protocol.pass":
    {
        "zh":u"\n系统文件共享服务检查通过。",
        "en":"\nThe system file sharing service check is passed.",
    }, 
"check.xnetPressure.notpass":
    {
        "zh":u"\n控制器[%s]：内存使用率大于70%%。",
        "en":"\nThe memory usage of controller [%s] is over 70%%.",
    },
"check.io.status.notpass":
    {
        "zh":u"\nI/O状态异常。",
        "en":"\nThe I/O status is abnormal.",
    },
"cannot.create.controller.cli":
    {
        "zh":u"\n无法连接该控制器，无法执行检查。",
        "en":"\nFailed to connect to the controller; therefore, the check cannot be performed.",
    },
"title.controller":
    {
        "zh":u"\n控制器[%s]： ",
        "en":"\nController[%s]: ",
    },
"cannot.ctrl.id.ip":
    {
        "zh":u"\n获取控制器信息失败。 ",
        "en":"\nThere is an error in getting controller information.",
    },
"check.cache.fault.notpass":
    {
        "zh":u"\ncache分区[%s]存在fault页面。",
        "en":"\nCache partition [%s] has fault pages.",
    },
"cli.result.is.invalid":
    {
        "zh":u"\n无效CLI信息。",
        "en":"\nInvalid Cli information.",
    },
"check.sys.processes.notpass":
    {
        "zh":u"\n存在正在执行或等待的系统流程。",
        "en":"\nSome system processes are being executed or waiting to be executed.",
    },
"check.reserver.memory.notpass":
    {
        "zh":u"\n预留内存不足。",
        "en":"\nThe reserved memory in the system is insufficient.",
    }, 
"check.sys.configlog.warn":
    {
        "zh":u"\n当前控制器不支持获取系统配置LOG信息，请连接集群主控制器重新执行评估。",
        "en":"\nObtaining system configuration logs are not supported by the current controller. Connect to the primary controller of the cluster and re-evaluate the upgrade.",
    }, 
"check.sys.configlog.notpass":
    {
        "zh":u"\nTotal log num与Remain free log num的值不相等，存在系统配置LOG。",
        "en":"\nThe values of the Total log num and Remain free log num field are not equal, system configuration logs exist.",
    },
"controller.check.pass":
    {
        "zh":u"\n检查通过。",
        "en":"\nCheck pass.",
    },
"install.onlyone.hotpatch":
    {
        "zh":u"\n请安装%s热补丁。",
        "en":"\nInstall the %s hot patch.",
    },
"install.many.hotpatch":
    {
        "zh":u"\n请依次安装%s热补丁。",
        "en":"\nInstall the %s hot patches in sequence.",
    },
"install.patch.hotpatch":
    {
        "zh":u"或以后版本",
        "en":"or its later version.",
     },
"comma.res":
    {
        "zh":u"，",
        "en":",",
    },
"disk.fw.ver.early":
    {
        "zh":u"\n固件版本过低的硬盘ID如下：\n%s",
        "en":"\nIDs of disks whose firmware versions are too early are as follows: \n%s"
    },
"cannot.get.disk.fw.model.failed":
    {
        "zh":u"\n无法获取固件版本和Model的硬盘如下：\n%s",
        "en":"\nDisks whose firmware version and Model cannot be obtained are as follows: \n%s",
    },
"portFCoE.notpass":
    {
        "zh": u"\n运行状态为已连接的FCoE端口有:%s",
        "en": "\nFCoE ports whose Running Status are Link Up involve: %s"
    },
"check.frontlink.result.nopass":
    {
        "zh":u"\n前端链路不冗余，不冗余的主机号为：%s",
        "en":"\nThere are no redundant front-end links. The ID of the host that is not redundant is %s.",
    },
"check.frontlink.result.queryInfoError":
    {
        "zh":u"\n无法获取信息的主机号为：%s",
        "en":"\nFailed to obtain the information of front-end links. The ID of the host is %s.",
    },
"check.frontlink.result.noOnlineInitiator":
    {
        "zh":u"\n启动器状态不在线的主机号为：%s",
        "en":"\nThe status of initiator is not online. The ID of the host is %s",
    },
"check.frontlink.result.noSupportIbLink":
    {
        "zh":u"\n以下主机无法获取到IB启动器的前端链路信息：%s",
        "en":"\nFailed to obtain the front-end links information of ib initiator. The ID of the host is %s",
    },
}