# -*- coding: UTF-8 -*-
from frame.tlv import tlvDataType

PUB_ATTR = {
    "type":{"index":0, "type":tlvDataType.DATA_TYPE_ENUM},
    "id":{"index":1, "type":tlvDataType.DATA_TYPE_STRING},
    "name":{"index":2, "type":tlvDataType.DATA_TYPE_STRING},
    "parentType":{"index":3, "type":tlvDataType.DATA_TYPE_ENUM},
    "parentID":{"index":4, "type":tlvDataType.DATA_TYPE_STRING},
    "parentName":{"index":5, "type":tlvDataType.DATA_TYPE_STRING},
    "location":{"index":6, "type":tlvDataType.DATA_TYPE_STRING},
    "healthStatus":{"index":7, "type":tlvDataType.DATA_TYPE_ENUM},
    "runningStatus":{"index":8, "type":tlvDataType.DATA_TYPE_ENUM},
    "queryCondition":{"index":15, "type":tlvDataType.DATA_TYPE_STRING},
}
    
    
CMD = {         
    "GET":55834574848,#查询单个对象
    "GET_BATCH_NEXT":55834624000,#批量查询对象
    "GET_CURRENT_ALARM":55847747648,#查询当前告警
    "MODIFY":55834583040,#修改对象
    "OM_MSG_OP_UPD_EXECUTE":8599117931,#通知执行一个升级流程，查询CPU利用率等信息
    "CHECK_IBC_PASSWORD":55847747746,#检查IBC密码是否为默认密码
    "EXPANSION_AD_PROCESS":56908316701,#IP Scale Out扩容,启停AD模块
    "EXPANSION_AD_NOTIFY":56908316702,#IP Scale Out扩容,下发是否扩容配置
    "EXPANSION_GET_BOARDS":56908316703,#IP Scale Out扩容,查询框和节点
    "EXPANSION_GET_ROUTE_INFO":56908316704,#IP Scale Out扩容,查询路由信息
    "EXPANSION_AD_FORWARD":56908316705,#IP Scale Out扩容,AD模块转发
    "READ_IP_CLUST_BASE_INFO":56908316706,#IP Scale Out扩容,获取基地址IP\组网类型\端口ID\交换机ID等
    "MODIFY_IP_CLUST_BASE_INFO":56908316707,#IP Scale Out扩容,修改配置文件基本信息
    "GET_EXPANSION_BAY_ID":55848009729,#IP Scale Out扩容,获取配置文件控制器数量
    "MODIFY_BAY_CONFIG":55848009732,#IP Scale Out扩容,修改控制器数量和柜ID
    "MODIFY_EXPAND_BAY":55848017920,#IP Scale Out扩容,修改控制器数量
    "CHANGE_BMC_INFO":56908316708,#修改BMC信息
    "CAPACITY_EXPAND":55848009730,#执行扩容
    "SYS_CLEAR_CONFIG":55847747678,#清除集群配置
    "STOP_FEED":3080266,#重启待扩容引擎
}

OM_OBJ_E = {    
    "ENCLOSURE":206,
    "CONTROLLER":207,
    "INTF_MODULE":209,
    "ETH_PORT":213,
    "SYSTEM":201,
    "BAY":205,
    "MEMORY":237,
    "FAN":211,
    "DISK":10,
    "BACKUP_POWER":210,
    "POWER":23,
    "EXPBOARD":208,
    "SAS_PORT":214,
    "FC_PORT":212,
    "SERIAL_PORT":215,
    "PCIE_PORT":233,
    "SFP_OPTICAL_TRANSCEIVER":234,
    "FCoE_PORT":252,
    "FAN_CTRL_MODULE":306,
    "IB_PORT":16500,
}

PID = {
   (CMD["CHECK_IBC_PASSWORD"],0):1006,
   (CMD["CHANGE_BMC_INFO"],0):47,
   (CMD["GET"],OM_OBJ_E["SYSTEM"]):47,
   (CMD["GET_BATCH_NEXT"],OM_OBJ_E["ENCLOSURE"]):47,
   (CMD["GET_BATCH_NEXT"],OM_OBJ_E["ETH_PORT"]):47,
   (CMD["GET_BATCH_NEXT"],OM_OBJ_E["INTF_MODULE"]):47,
   (CMD["GET_BATCH_NEXT"],OM_OBJ_E["CONTROLLER"]):47,
   (CMD["GET_BATCH_NEXT"],OM_OBJ_E["MEMORY"]):47,
   (CMD["GET_CURRENT_ALARM"],0):49,
   (CMD["OM_MSG_OP_UPD_EXECUTE"],0):1009,
   (CMD["MODIFY"],OM_OBJ_E["ENCLOSURE"]):47,
   (CMD["MODIFY"],OM_OBJ_E["BAY"]):47,
   (CMD["MODIFY_BAY_CONFIG"], OM_OBJ_E["BAY"]):47,
   (CMD["MODIFY_IP_CLUST_BASE_INFO"],0):48,
   (CMD["READ_IP_CLUST_BASE_INFO"],0):48,
   (CMD["SYS_CLEAR_CONFIG"],0):962,
   (CMD["STOP_FEED"],0):47,
}

ENCLOSURE_MODEL = {
    0:"CTRL_BMC",#BMC控制框/
    1:"CTRL_SAS2U_12",#2U SAS 12盘主控框/
    2:"CTRL_SAS2U_24",#2U SAS 24盘主控框/
    16:"EXPSAS2U_12",#2U SAS 12盘级联框/
    17:"EXPSAS2U_24",#2U SAS 24盘级联框/
    18:"EXPSAS4U",#4U SAS 24盘级联框/
    19:"EXPFC",#4U FC 24盘级联框/
    20:"DSW_PCIe1U",#1U PCIe数据交换机/
    21:"EXPSAS4U_75",#4U SAS 75盘级联框/
    22:"SVP",#SVP/SVP Controller Enclosure
    97:"CTRL_6U",#6U 4控独立机头/
    96:"CTRL_3U",#3U 2控独立机头/
    24:"EXPSAS2U_25",#2U SAS 25盘2.5寸磁盘框/
    25:"EXPSAS4U_24_NEW",#4U SAS 24盘3.5寸磁盘框（新）/
    26:"CTRL_12GSAS_2U25_EAR",#2U 12GSAS 25盘主控框/
    23:"CTRL_12GSAS_2U12_EAR",#2U 12GSAS 12盘主控框/
}

ENCLOSURE_TYPE = {
    0:"EXP",#级联框（硬盘框）/
    1:"CTRL",#控制框/
    2:"DSW",#数据交换机/
    3:"MSW",#管理交换机/
    4:"SVP"#管理服务器/
}

INTF_MODEL = {
    1:"FC_4X4G",#4x4G FC接口模块/4x4G FC Interface Module
    2:"FC_2X4G",#2x4G FC接口模块/2x4G FC Interface Module
    3:"GE_RJ45_2X",#2xGE 电接口模块/2xGE Electrical Interface Module
    4:"SASI_4X",#4xSAS I 接口模块/4xSAS I Interface Module
    5:"FC_4X4G_EXPAND",#Swapped FC接口模块/Swapped FC Interface Module
    6:"ETH10G_2",#2x10GE 光接口模块/2x10GE Optical Interface Module
    7:"FC_1X8G",#1x8G FC光接口模块/1x8G FC Optical Interface Module
    8:"FC_2X8G""FC_2X8G",#2x8G FC光接口模块/2x8G FC Optical Interface Module
    9:"SASII_2X",#2xSAS II电接口模块/2xSAS II Electrical Interface Module
    10:"SASII_4X",#4xSAS II电接口模块/4xSAS II Electrical Interface Module
    11:"Combo_2FCx2GE",#2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
    12:"iSCSI_4X",#4xGE 电接口模块/4xGE Electrical Interface Module
    13:"FC_4X8G",#4x8G FC光接口模块/4x8G FC Optical Interface Module
    16:"MINISAS_4X",#4xmini-SAS接口模块/4x mini-SAS Interface Module
    21:"FCoE_4X",#4x10G FCoE光接口模块/4x10G Optical Interface Module
    22:"SASA_2X6G",#2x6G SASA接口模块/2x6G SASA Interface Module
    23:"SASB_2X6G",#2x6G SASB接口模块/2x6G SASB Interface Module
    24:"ManagerBoard",#管理板/Management Board
    25:"TOE",#4x10GE接口模块/4x10GE Interface Module
    26:"PCIe_2X5G",#2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
    27:"FCoE_2X",#2x10G FCoE光接口模块/2x10G Optical Interface Module
    28:"iSCSI_4XGE",#4xGE Optical Interface Module/4xGE光接口模块
    29:"FC_2X16G",#2x16G FC Optical Interface Module    2x16G FC光接口模块
    30:"SAS_4X12G",#4x12SAS QSFP Interface Module    4x12G SAS光电接口模块
    31:"iSCSI_4X10",#4x10GE Electrical Interface Module    4x10GE 电接口模块
    32:"IB_2x40G",#2x40GE Infiniband Interface Module    2x40GE IB接口模块
    33:"IB_2x56G",#2x56GE Infiniband Interface Module    2x56GE IB接口模块
    34:"GE_RJ45_4X",#4xGE Electrical Interface Module    4xGE 电接口模块
    35:"AccerationEngineCard",#Express Module（ACC，Acceration engine）    重删压缩加速卡
    36:"IOC_4X10G_RJ45",#4x10GE Electrical Interface Module    4x10GE 电接口模块
    37:"IOC_4XSMART",#4xSMART Optical Interface Module    4xSMART 光接口模块
    38:"IOC_8X8G_FC",#8x8G FC Optical Interface Module    8x8G FC光接口模块
    39:"IOC_4X8G_FC",#4x8G FC Optical Interface Module    4x8G FC光接口卡
    40:"IOC_4X16G_FC",#4x16G FC Optical Interface Module    4x16G FC光接口卡
    41:"SAS_12PORT_BACKEND_MODULE",#12 port 4*12Gb SAS Back-End Interconnect I/O Module     12端口4*12Gb SAS后端全互联IO模块
}

EXPBOARD_TYPE = {
    0:"SAS",
    1:"FC",
}

BMC_CHANGE_MODE_E = {
    "change":0,
    "delete":1, 
    "set":2,
    "sync":3,
}

PRODUCT_MODE_E = {
    "V1500":0,#V1500/V1500
    "V1800":1,#V1800/V1800
    "S2100":2,#S2100/S2100
    "S2300":3,#S2300/S2300
    "S5100":4,#S5100/S5100
    "S5300":5,#S5300/S5300
    "S5500":6,#S5500/S5500
    "S5600":7,#S5600/S5600
    "VIS":8,#VIS/VIS
    "S2600":9,#S2600/S2600
    "S6800E":10,#S6800E/S6800E
    "V1500N":11,#V1500N/V1500N
    "S2300E":12,#S2300E/S2300E
    "COMMON":13,#COMMON(插框混用)/COMMON
    "N8000":15,#N8000/N8000
    "S6900":16,#S6900/S6900
    "S3900":17,#S3900/S3900
    "S5500T":18,#S5500T/S5500T
    "S5600T":19,#S5600T/S5600T
    "S6800T":20,#S6800T/S6800T
    "S6900_M100":21,#S6900-M100/S6900-M100
    "S3900_M200":22,#S3900-M200/S3900-M200
    "S3900_M300":23,#S3900-M300/S3900-M300
    "S5900_M100":24,#S5900-M100/S5900-M100
    "S8100":25,#S8100/S8100
    "S5800T":26,#S5800T/S5800T
    "V1600N":27,#V1600N/V1600N
    "S5900_M200":28,#S5900-M200/S5900-M200
    "N8001":29,#N8001/N8001
    "S2600T":30,#S2600T/S2600T
    "S8000_I":31,#S8000-I/S8000-I
    "Dorado5100":32,#Dorado5100/Dorado5100
    "T3200":33,#T3200/T3200
    "T3500":34,#T3500/T3500
    "N8000-R710":35,#N8000-R710/N8000-R710
    "N8000-C2":36,#N8000-C2/N8000-C2
    "N8000-C2-SYMC":40,#N8000-C2-SYMC/N8000-C2-SYMC
    "VTL":41,#VTL/VTL
    "S2900":42,#S2900/S2900
    "S2200T":43,#S2200T/S2200T
    "Dorado2100 G2":44,#Dorado2100 G2/Dorado2100 G2
    "VIS 6000":45,#VIS 6000/VIS 6000
    "HVS85T":46,#HVS85T/HVS85T
    "HVS88T":47,#HVS88T/HVS88T
    "9000":48,#9000/9000
    "T3200 G2":49,#T3200 G2/T3200 G2
    "T3500 G2":50,#T3500 G2/T3500 G2
    "T3200 G3":51,#T3200 G3/T3200 G3
    "T3500 G3":52,#T3500 G3/T3500 G3
    "S5700":53,#S5700/S5700
    "CE6800":54,#CE6800/CE6800
    "CE12800":55,#CE12800/CE12800
    "HVS_18800F":56,#HVS的纯SSD盘版本/18800F
    "HVS_18500":57,#HVS的18500型号/18500
    "HVS_18800":58,#HVS的18800型号/18800
    "SSS":60,#SSS/SSS
    "6800 V3":61,#中低端V3/6800V3-6U-2/4C
    "6900 V3":62,#中低端V3/6900V3-6U-4C
    "5600 V3":63,#中低端V3/5600V3-3U2C
    "5800 V3":64,#中低端V3/5800V3-3U2C
    "T3200 MINI":65,#T3200/T3200/9000 C01版本(建行项目新增)
    "WUSHAN_SQL":66,#WUSHAN_SQL/WUSHAN_SQL/9000 C10版本
    "WUSHAN_HD":67,#WUSHAN_HD/WUSHAN_HD/9000 C10版本
    "5500 V3":68,#5500 V3/5500 V3/2U盘控一体 5500 V3
    "2600 V3":69,#2600 V3/2600 V3/2U盘控一体 2600 V3
    "5300 V3":70,#5300 V3/5300 V3/2U盘控一体 5300 V3
    "N5000":401,#N5000/N5000
    "VIS8200":800,#VIS8200/VIS8200
    "VIS8400":801,#VIS8400/VIS8400
    "VIS8600":802,#VIS8600/VIS8600
    "VIS8800":803#VIS8800/VIS8800
}

HEALTH_STATUS_E = {
    "UNKNOWN":0,#未知/--
    "NORMAL":1,#正常/Normal
    "FAULT":2,#故障/Fault
    "PRE_FAIL":3,#即将故障/Pre-Fail
    "PART_BROKEN":4,#部分损坏/partially broken
    "DEGRADE":5,#降级/Degraded
    "HAS_BAD_BLOCK":6,#有坏块/Bad sectors found
    "HAS_ERR_CODE":7,#有误码/Bit errors found
    "CONSISTENT":8,#一致/Consistent
    "INCONSISTENT":9,#不一致/Inconsistent
    "BUSY":10,#繁忙/Busy
    "POWER_NO_INPUT":11,#无输入/No input
    "POWER_NOT_ENOUGH":12,#电量不足/Low battery
    "SINGLE_LINK_FAULT":13#单链路故障/Single link fault
}

RUNNING_STATUS_E = {
    "UNKNOWN":0,#未知/--
    "NORMAL":1,#正常/Normal
    "RUNNING":2,#运行/Running
    "NOT_RUNNING":3,#未运行/Not running
    "NOT_EXIST":4,#不存在/Not existed
    "HIGH_TEMPERATURE_SLEEP":5,#高温休眠/Sleep in high temperature
    "STARTING":6,#正在启动/Starting
    "POWER_FAILURE_PROTECTING":7,#掉电保护/Power failure protection
    "SLEEPING":8,#休眠/Spin down
    "SPINGUP":9,#已启动/Started
    "LINK_UP":10,#已连接/Link Up
    "LINK_DOWN":11,#未连接/Link Down
    "POWER_ON":12,#正在上电/Powering on
    "POWER_OFF":13,#已下电/Powered off
    "PRE_COPY":14,#预拷贝/Precopy
    "COPYBACK":15,#回拷/Copyback
    "RECONSTRUCTION":16,#重构/Reconstruction
    "EXPANSION":17,#扩容/Expansion
    "NOT_FORMAT":18,#未格式化/Unformatted
    "FORMATTING":19,#正在格式化/Formatting
    "UNMAPPING":20,#未映射/Unmapped
    "INITIAL_SYNCHRONIZING":21,#正在初始同步/Initial synchronizing
    "CONSISTENT":22,#数据一致/Consistent
    "SYNCHRONIZING":23,#正在同步/Synchronizing
    "SYNCHRONIZED":24,#已同步/Synchronized
    "NOT_SYNCHRONIZED":25,#未同步/Unsynchronized
    "SPLIT":26,#已分裂/Splited
    "ONLINE":27,#在线/Online
    "OFFLINE":28,#离线/Offline
    "LOCKED":29,#已锁定/Locked
    "ENABLE":30,#已启用/Enabled
    "DISABLED":31,#已禁用/Disabled
    "LEVELING":32,#正在均衡/balancing
    "TO_BE_RECOVERD":33,#待恢复/To be recovered
    "INTERRUPTED":34,#异常断开/Interrupted
    "INVALID":35,#失效/Invalid
    "NOSTART":36,#新创建/Not start
    "QUEUING":37,#正在排队/Queuing
    "STOP":38,#已停止/Stopped
    "COPYING":39,#正在拷贝/Copying
    "COMPLETED":40,#拷贝完成/Completed
    "PAUSE":41,#暂停/Paused
    "REVSYNCHRONIZING":42,#正在反向同步/Reverse synchronizing
    "ACTIVATED":43,#已激活/Activated
    "ROLLBACK":44,#正在回滚/Restore
    "INACTIVATED":45,#未激活/Inactive
    "IDLE":46,#等待/Idle
    "POWERING_OFF":47,#正在下电/Powering off
    "CHARGING":48,#正在充电/Charging
    "CHARGED":49,#充电完成/Charging completed
    "DISCHARGING":50,#正在放电/Discharging
    "UPGRADING":51,#正在升级/Upgrading
    "POWER_LOST":52,#掉电中/Power Lost
    "INITIALIZING":53,#初始化中/Initializing
    "APPLY_CONFIG_CHANGE":54,#正在应用变更/Apply Change
    "ONLINE_DISABLE":55,#在线禁用/online disable
    "OFFLINE_DISABLE":56,#离线禁用/Offline disable
    "ONLINE_FROZEN":57,#在线冻结/online frozen
    "OFFLINE_FROZEN":58,#离线冻结/offline frozen
    "CLOSED":59,#已关闭/closed
    "REMOVING":60,#(节点)删除中/removing
    "INSERVICE":61,#服务中/in service
    "OUTOFSERVICE":62,#退出服务/out of service
    "ERASEMENT_RUNNING_NORMAL":63,#正在销毁/Running normal
    "ERASEMENT_RUNNING_FAIL":64,#销毁失败/Running fail
    "ERASEMENT_RUNNING_SUCCESS":65,#销毁成功/Running success
    "SUCCESS":66,#任务执行成功/Running success
    "FAILED":67,#任务执行失败/Running failed
    "WAITING":68,#任务正在等待/Waiting
    "CANCELLING":69,#任务正在取消/Cancelling
    "CANCELLED":70,#任务已取消/Cancelled
    "RUNNING_PREPARE_SYNC":71,#在线|即将灾备同步/About to synchronize
    "RUNNING_SYNCHRONINING":72,#在线|正在灾备同步/Synchronizing data
    "RUNNING_SYNC_FAILED":73,#在线|灾备同步失败/Failed to synchronize
    "MIGRATION_FAULT":74,#迁移故障/MIGRATION_FAULT
    "MiGRATING":75,#迁移中/MiGRATING
    "MIGRATION_COMPLETED":76#迁移完成/MIGRATION_COMPLETED
}

PORT_LOGIC_TYPE_E = {
    "HOST":0,#主机端口/业务端口
    "EXP":1,#级联端口
    "MNGT":2,#管理端口
    "INNER":3,#内部端口
    "MAINTENANCE":4,#维护端口
    "MNGT_SRV":5,#管理/业务混合口
    "MAINTENANCE_SRV":6,#维护/业务混合口
    "BACKUP_MGR":7,#备份管理网口
    "PRODUCT_STORAGE":8,#生产存储网口
    "BACKUP_STORAGE":9,#备份存储网口
    "ETH_NOT_CONFIG":10#未配置角色网口
}

ENCLOSURE_TYPE_E = {
    "EXP":0,#级联框（硬盘框）
    "CTRL":1,#控制框
    "DSW":2,#数据交换机
    "MSW":3,#管理交换机
    "SVP":4#管理服务器
}

INTF_MODEL_E = {
    "FC_4X4G":1,#4x4G FC接口模块/4x4G FC Interface Module
    "FC_2X4G":2,#2x4G FC接口模块/2x4G FC Interface Module
    "GE_RJ45_2X":3,#2xGE 电接口模块/2xGE Electrical Interface Module
    "SASI_4X":4,#4xSAS I 接口模块/4xSAS I Interface Module
    "FC_4X4G_EXPAND":5,#Swapped FC接口模块/Swapped FC Interface Module
    "ETH10G_2":6,#2x10GE 光接口模块/2x10GE Optical Interface Module
    "FC_1X8G":7,#1x8G FC光接口模块/1x8G FC Optical Interface Module
    "FC_2X8G":8,#2x8G FC光接口模块/2x8G FC Optical Interface Module
    "SASII_2X":9,#2xSAS II电接口模块/2xSAS II Electrical Interface Module
    "SASII_4X":10,#4xSAS II电接口模块/4xSAS II Electrical Interface Module
    "Combo_2FCx2GE":11,#2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
    "iSCSI_4X":12,#4xGE 电接口模块/4xGE Electrical Interface Module
    "FC_4X8G":13,#4x8G FC光接口模块/4x8G FC Optical Interface Module
    "MINISAS_4X":16,#4xmini-SAS接口模块/4x mini-SAS Interface Module
    "FCoE_4X":21,#4x10G FCoE光接口模块/4x10G Optical Interface Module
    "SASA_2X6G":22,#2x6G SASA接口模块/2x6G SASA Interface Module
    "SASB_2X6G":23,#2x6G SASB接口模块/2x6G SASB Interface Module
    "ManagerBoard":24,#管理板/Management Board
    "TOE":25,#4x10GE接口模块/4x10GE Interface Module
    "PCIe_2X5G":26,#2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
    "FCoE_2X":27,#2x10G FCoE光接口模块/2x10G Optical Interface Module
    "iSCSI_4XGE":28,#4xGE Optical Interface Module/4xGE光接口模块
    "FC_2X16G":29,#2x16G FC Optical Interface Module    2x16G FC光接口模块
    "SAS_4X12G":30,#4x12SAS QSFP Interface Module    4x12G SAS光电接口模块
    "iSCSI_4X10":31,#4x10GE Electrical Interface Module    4x10GE 电接口模块
    "IB_2x40G":32,#2x40GE Infiniband Interface Module    2x40GE IB接口模块
    "IB_2x56G":33,#2x56GE Infiniband Interface Module    2x56GE IB接口模块
    "GE_RJ45_4X":34,#4xGE Electrical Interface Module    4xGE 电接口模块
    "AccerationEngineCard":35,#Express Module（ACC，Acceration engine）    重删压缩加速卡
    "IOC_4X10G_RJ45":36,#4x10GE Electrical Interface Module    4x10GE 电接口模块
    "IOC_4XSMART":37,#4xSMART Optical Interface Module    4xSMART 光接口模块
    "IOC_8X8G_FC":38,#8x8G FC Optical Interface Module    8x8G FC光接口模块
    "IOC_4X8G_FC":39,#4x8G FC Optical Interface Module    4x8G FC光接口卡
    "IOC_4X16G_FC":40,#4x16G FC Optical Interface Module    4x16G FC光接口卡
}

ENCLOSURE = {
    "model":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},
    "logicType":{"index":65, "type":tlvDataType.DATA_TYPE_ENUM},
    "serialNum":{"index":68, "type":tlvDataType.DATA_TYPE_STRING},
    "height":{"index":70, "type":tlvDataType.DATA_TYPE_SIGN_INT},
    "expanderDepth":{"index":71, "type":tlvDataType.DATA_TYPE_SIGN_INT},
    "expanderPort":{"index":72, "type":tlvDataType.DATA_TYPE_STRING},
    "switch":{"index":73, "type":tlvDataType.DATA_TYPE_ENUM},
}

EXPBOARD = {
    "model":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},#型号, enum
    "logicVer":{"index":65, "type":tlvDataType.DATA_TYPE_STRING},#逻辑版本, string
    "pcbVer":{"index":66, "type":tlvDataType.DATA_TYPE_STRING},#PCB版本, string
    "sesVer":{"index":67, "type":tlvDataType.DATA_TYPE_STRING},#SES版本, string
    "elabel":{"index":68, "type":tlvDataType.DATA_TYPE_STRING},#电子标签, string
    "lightStatus":{"index":70, "type":tlvDataType.DATA_TYPE_ENUM},#定位灯, enum
}

CONTROLLER = {
    "sesVer":{"index":69, "type":tlvDataType.DATA_TYPE_STRING},
}

INTF_MODULE = {
    "model":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},
    "lightStatus":{"index":69, "type":tlvDataType.DATA_TYPE_ENUM},
    "runMode":{"index":71, "type":tlvDataType.DATA_TYPE_ENUM},
}

SAS_PORT = {
    "logicType":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},
    "runSpeed":{"index":65, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "current_peer_port_id":{"index":75, "type":tlvDataType.DATA_TYPE_STRING},
    "suggest_peer_port_id":{"index":76, "type":tlvDataType.DATA_TYPE_STRING},
    "lightStatus":{"index":77, "type":tlvDataType.DATA_TYPE_ENUM},
    "enclosureWWNList":{"index":80, "type":tlvDataType.DATA_TYPE_STRING},
}

PCIE_PORT = {
    "pcieSpeed":{"index":64, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "current_peer_port_id":{"index":65, "type":tlvDataType.DATA_TYPE_STRING},
    "suggest_peer_port_id":{"index":66, "type":tlvDataType.DATA_TYPE_STRING},
    "lightStatus":{"index":69, "type":tlvDataType.DATA_TYPE_ENUM},
}
        
SYSTEM = {      
    "healthStatus":{"index":7, "type":tlvDataType.DATA_TYPE_ENUM},
    "runningStatus":{"index":8, "type":tlvDataType.DATA_TYPE_ENUM},
    "productMode":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},
    "productVersion":{"index":65, "type":tlvDataType.DATA_TYPE_STRING},
}

IP_CLUST_BASE_INFO = {
   "baseIpAddr":{"index":0, "type":tlvDataType.DATA_TYPE_STRING},
   "netMode":{"index":1, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctraPortID1":{"index":2, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctraDswID1":{"index":3, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctraPortID2":{"index":4, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctraDswID2":{"index":5, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctraPortID3":{"index":6, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctraDswID3":{"index":7, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctraPortID4":{"index":8, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctraDswID4":{"index":9, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrbPortID1":{"index":10, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrbDswID1":{"index":11, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrbPortID2":{"index":12, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrbDswID2":{"index":13, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrbPortID3":{"index":14, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrbDswID3":{"index":15, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrbPortID4":{"index":16, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrbDswID4":{"index":17, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrcPortID1":{"index":18, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrcDswID1":{"index":19, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrcPortID2":{"index":20, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrcDswID2":{"index":21, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrcPortID3":{"index":22, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrcDswID3":{"index":23, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrcPortID4":{"index":24, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrcDswID4":{"index":25, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrdPortID1":{"index":26, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrdDswID1":{"index":27, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrdPortID2":{"index":28, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrdDswID2":{"index":29, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrdPortID3":{"index":30, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrdDswID3":{"index":31, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
   "ctrdPortID4":{"index":32, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
   "ctrdDswID4":{"index":33, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

CHECK_IBC_PASSWORD = {
    "passwordChanged":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "keyPairChanged":{"index":1, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

MEMORY = {
    "capacity":{"index":65, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
}

BAY = {
    "type":{"index":0, "type":tlvDataType.DATA_TYPE_ENUM},
    "id":{"index":1, "type":tlvDataType.DATA_TYPE_STRING},
    "name":{"index":2, "type":tlvDataType.DATA_TYPE_STRING},
    "location":{"index":6, "type":tlvDataType.DATA_TYPE_STRING},
    "model":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},
    "newID":{"index":65, "type":tlvDataType.DATA_TYPE_STRING},
    "contrlTotal":{"index":68, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "isIpScaleOut":{"index":69, "type":tlvDataType.DATA_TYPE_BOOL},
}

EXPANSION_AD_FORWARD_DEFINE = {
    "enclosureSN":{"index":1000, "type":tlvDataType.DATA_TYPE_STRING},
    "controllerID":{"index":1001, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "pid":{"index":1002, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "cmd":{"index":1003, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
    "obj":{"index":1004, "type":tlvDataType.DATA_TYPE_ENUM},
}

EXPANSION_GET_BOARDS_DEFINE = {
    "enclosureSN":{"index":0, "type":tlvDataType.DATA_TYPE_STRING},
    "controllerID":{"index":1, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

EXPANSION_AD_PROCESS_DEFINE = {
    "status":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},#0：启动 1：停止
    "successNum":{"index":1, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},#启动或停止时返回网管成功个数                       
}

EXPANSION_AD_NOTIFY_DEFINE = {
    "status":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},#0：开局部署 1：扩容
    "result":{"index":1, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},#0：失败 1：成功                                   
}

EXPANSION_GET_ROUTE_INFO_DEFINE = {
    "srcEnclosureSN":{"index":0, "type":tlvDataType.DATA_TYPE_STRING},
    "srcControllerID":{"index":1, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "srcPortMacAddr":{"index":2, "type":tlvDataType.DATA_TYPE_STRING},
    "desEnclosureSN":{"index":3, "type":tlvDataType.DATA_TYPE_STRING},
    "desControllerID":{"index":4, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "desPortMacAddr":{"index":5, "type":tlvDataType.DATA_TYPE_STRING},
}

ETH_PORT = {
    "logicType":{"index":64, "type":tlvDataType.DATA_TYPE_ENUM},
    "macAddress":{"index":65, "type":tlvDataType.DATA_TYPE_STRING},
    "lightStatus":{"index":85, "type":tlvDataType.DATA_TYPE_ENUM},
    "speed":{"index":84, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "interfaceModelType":{"index":94, "type": tlvDataType.DATA_TYPE_ENUM},
}

CMO_ALARM_INFO_E = {
    "CMO_ALARM_TYPE":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_ALARM_ID":{"index":1, "type":tlvDataType.DATA_TYPE_U64LONG_TYPE},
    "CMO_ALARM_LEVEL":{"index":2, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_ALARM_CLEAR_TIME":{"index":5, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_ALARM_RECOVERY_TIME":{"index":6, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_ALARM_COUNT":{"index":9, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

BMC_INFO_DEFINE = {
   "flag":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

STOP_FEED_DEFINE = {
   "bitMap":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

#------------------------------------------------------------------------------
#评估工具使用的

CMO_NOTIFY_EXC_UPGRADE_DEFINE = {
    "CMO_EXE_UPD_MSGTYPE":{"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_EXE_UPD_NIDLIST":{"index":1, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_ACTIVETYPE":{"index":2, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_EXE_UPD_BAKPATH":{"index":3, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_EXENODETYPE":{"index":4, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_EXEFLOW":{"index":5, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_EXEFLOWSEGMENT":{"index":6, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_EXEATOM":{"index":7, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_SYNCPAR":{"index":8, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXE_UPD_PKG_TYPE":{"index":9, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_EXC_DIAG_CMD":{"index":12, "type":tlvDataType.DATA_TYPE_STRING},
    "CMO_EXC_NODE_CFG":{"index":13, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    
    "CMO_EXC_CHECKTYPE":{"index":64, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
    "CMO_EXC_ISINNER":{"index":67, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},  
}

UPD_MSG_E = {
    "EXE_UPD_MSGTYPE":0,
    "EXE_UPD_NIDLIST":"",
    "EXE_UPD_ACTIVETYPE":0,
    "EXE_UPD_BAKPATH":"",
    "EXE_UPD_EXENODETYPE":"",
    "EXC_NODE_CFG":1,
    "CMO_EXC_CHECKTYPE":0,
    "CMO_EXC_ISINNER":0,
}

#必须和UPD_CMD_DEFINE的名字保持一致
UPD_SPECIAL_CMD = {
    "CHECK_SOFTWARE_VMMACHINE_SHUTDWON":55847747925,#虚拟机是否关闭接口的Opcode
}

CMO_UPD_EXECUTE_DEFINE = {
    "NODE_ID":{"index":0, "type":tlvDataType.DATA_TYPE_STRING},
    "RESULT":{"index":1, "type":tlvDataType.DATA_TYPE_STRING},
    "CONTROLLER_ID":{"index":65, "type":tlvDataType.DATA_TYPE_STRING},
    "CONTROLLER_NUM":{"index":66, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},
}

#升级前检查发送给升级模块的命令,其中id表示通知升级模块要在那个节点执行,1:在集群主上执行,2:在所有节点执行
UPD_CMD_DEFINE = {
    "CHECK_SOFTWARE_RESERVED_MEMORY":{"cmd":"sys ismemusedup", "id":2},#检查系统预留内存
    "CHECK_SOFTWARE_SYSCOMPATIBLE":{"cmd":"upd syscompatiblecheck", "id":2},#检查系统版本兼容性
    "CHECK_SOFTWARE_FIRMWARE_COMPATIBLE":{"cmd":"upg checkfwverinfo", "id":2},#检查固件版本兼容性
    "CHECK_SOFTWARE_SYSSTATUS":{"cmd":"sys issysnormal", "id":1},#检查系统故障
    "CHECK_SOFTWARE_SYSRESOURCE":{"cmd":"upd sysresourcecheck", "id":2},#检查系统资源
    "CHECK_SOFTWARE_VERSIONCONSISTANCE":{"cmd":"upd issameversion", "id":2},#检查控制器版本是否一致
    "CHECK_SOFTWARE_SYSPRESSURE":{"cmd":"sys issystembusy", "id":1},#检查系统运行压力
    "CHECK_SOFTWARE_DOUBLECTRL":{"cmd":"sys isalldoublectrl", "id":2},#检查引擎是否为双控
    "CHECK_SOFTWARE_XNETPRESSURE":{"cmd":"xnet checkpressure", "id":2},#检查Xnet压力
    "CHECK_SOFTWARE_SYS_CONFIGLOG":{"cmd":"sys showcfglog", "id":1},#检查系统配置LOG
    "CHECK_SOFTWARE_FRONT_PRESSURE":{"cmd":"ioperf iobandwidth 5", "id":2},#检查系统前端压力
    "CHECK_SOFTWARE_SYSALARM":{"cmd":"upg UrgentAlm", "id":1},#检查系统告警
    "CHECK_SOFTWARE_PROTOCOL":{"cmd":"proto upgrade precheck", "id":2},#系统文件共享服务检查
    
    "CHECK_HARDWARE_BBUPOWER":{"cmd":"upg checkbbupower", "id":2},#检查BBU电量是否充足
    "CHECK_HARDWARE_PCIE_LINKSTATUS":{"cmd":"upd checkpcielink", "id":1},#PCIe链路检查
    
    "CHECK_DISK_USAGE":{"cmd":"upd diskusagecheck", "id":2},#检查磁盘利用率
    "CHECK_DISK_SLOWDISK":{"cmd":"ld checkdiskslow", "id":1},#检查慢盘
    "CHECK_DISK_LINKSTATUS":{"cmd":"ld checksinglelink", "id":2},#检查磁盘单链路
    "CHECK_DISK_ISDISKDIAGNOSE":{"cmd":"sddebug checkdiag", "id":2},#检查磁盘单链路
    
    "CHECK_SERVICE_DISKDOMAINSTATUS":{"cmd":"pmgr isallpoolcanupgrade", "id":2},#检查硬盘域状态
    "CHECK_SERVICE_EXTLUN_LINKSTATUS":{"cmd":"ld checkextlunsinglelink", "id":1},#检查外部LUN链路状态
    
    "CHECK_SOFTWARE_VMMACHINE_SHUTDWON":{"CMO_EXC_CHECKTYPE":0,"CMO_EXC_ISINNER":0},#所有虚拟机是否关闭检测
}

#升级检查返回结果字典定义
UPD_CHECK_RESULT = {
    "CHECK_SOFTWARE_RESERVED_MEMORY":{
            "TimeOut":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.reserved.memory.notpass", "status":False},
            "False":{"msg":"check.reserved.memory.pass", "status":True},
    },
    "CHECK_SOFTWARE_SYSCOMPATIBLE":{
            "TimeOut":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.syssoftware.compatible.notpass", "status":False},
            "True":{"msg":"check.syssoftware.compatible.pass", "status":True},
    },
    "CHECK_SOFTWARE_FIRMWARE_COMPATIBLE":{
            "TimeOut":{"msg":"check.result.timeout", "status":False},
            "success":{"msg":"check.fwversion.compatible.pass", "status":True},
            "fail":{"msg":"check.fwversion.compatible.notpass", "status":False},
    },
    "CHECK_SOFTWARE_SYSSTATUS":{
            "TimeOut":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.system.status.pass", "status":True},
            "False":{"msg":"check.system.status.notpass", "status":False},
    },
    "CHECK_SOFTWARE_SYSRESOURCE":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.system.resource.notpass", "status":False},
            "True":{"msg":"check.system.resource.pass", "status":True},
    },
    "CHECK_SOFTWARE_VERSIONCONSISTANCE":{
            "timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.version.consistance.notpass", "status":False},
            "True":{"msg":"check.version.consistance.pass", "status":True},
    },
    "CHECK_SOFTWARE_SYSPRESSURE":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.system.pressure.notpass", "status":False},
            "False":{"msg":"check.system.pressure.pass", "status":True},
    },
    "CHECK_SOFTWARE_DOUBLECTRL":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.double.controller.notpass", "status":False},
            "True":{"msg":"check.double.controller.pass", "status":True},
    },
    "CHECK_SOFTWARE_XNETPRESSURE":{
            "TimeOut":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.xnet.pressure.pass", "status":True},
            "True":{"msg":"check.xnet.pressure.notpass", "status":False},
    },
    "CHECK_SOFTWARE_SYS_CONFIGLOG":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.system_config.log.notpass", "status":False},
            "True":{"msg":"check.system_config.log.pass", "status":True},
    },
    "CHECK_SOFTWARE_FRONT_PRESSURE":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.front.pressure.notpass", "status":False},
            "True":{"msg":"check.front.pressure.pass", "status":True},
    },
    "CHECK_SOFTWARE_SYSALARM":{
            "TimeOut":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.system.alarm.notpass", "status":False},
            "False":{"msg":"check.system.alarm.pass", "status":True}, 
    },
    "CHECK_SOFTWARE_VMMACHINE_SHUTDWON":{
            0:{"msg":"check.vm.machine.shutdown.pass", "status":True},
            1:{"msg":"check.vm.machine.shutdown.notpass", "status":False},
            2:{"msg":"check.result.timeout", "status":False},
            4:{"msg":"check.vm.machine.shutdown.pass", "status":True},
    },
    "CHECK_SOFTWARE_PROTOCOL":{
            "True":{"msg":"check.protocol.pass", "status":True},
            "False":{"msg":"check.protocol.notpass", "status":False},
            "TimeOut":{"msg":"check.result.timeout", "status":False},
    },
    "CHECK_HARDWARE_BBUPOWER":{
           "Timeout":{"msg":"check.hardware.BBUPower.timeout", "status":False},
           "True":{"msg":"check.hardware.BBUPower.pass", "status":True},
           "False":{"msg":"check.hardware.BBUPower.notpass", "status":False},
           "input command error":{"msg":"check.hardware.BBUPower.pass", "status":True},          
    },
    "CHECK_HARDWARE_PCIE_LINKSTATUS":{
           "Timeout":{"msg":"check.result.timeout", "status":False},
           "True":{"msg":"check.hardware.PCIESingleLink.pass", "status":True},
           "False":{"msg":"check.hardware.PCIESingleLink.notpass", "status":False},                   
    },
    "CHECK_DISK_USAGE":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.disk.usage.notpass", "status":False},
            "True":{"msg":"check.disk.usage.pass", "status":True}, 
    },
    "CHECK_DISK_SLOWDISK":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.disk.slow.notpass", "status":False},
            "False":{"msg":"check.disk.slow.pass", "status":True}, 
            "unsupported command":{"msg":"check.disk.slow.pass", "status":True}, 
    },
    "CHECK_DISK_LINKSTATUS":{
           "Timeout":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.disk.singlelink.notpass", "status":False},
            "False":{"msg":"check.disk.singlelink.pass", "status":True},
            "unsupported command":{"msg":"check.disk.singlelink.pass", "status":True},                   
    },
    "CHECK_DISK_ISDISKDIAGNOSE":{
           "Timeout":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.disk.isDiskInDiagnose.notpass", "status":False},
            "False":{"msg":"check.disk.isDiskInDiagnose.pass", "status":True},                   
    },
    "CHECK_SERVICE_DISKDOMAINSTATUS":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "False":{"msg":"check.diskdomain.status.notpass", "status":False},
            "True":{"msg":"check.diskdomain.status.pass", "status":True}, 
    },
    "CHECK_SERVICE_EXTLUN_LINKSTATUS":{
            "Timeout":{"msg":"check.result.timeout", "status":False},
            "True":{"msg":"check.extlunlink.status.notpass", "status":False},
            "False":{"msg":"check.extlunlink.status.pass", "status":True}, 
    },
}