﻿# -*- coding: UTF-8 -*-
import os
from common.constant import CheckedResult
from common.contextUtil import getPdtVer,getDestVer,getDevType,getUpgradeModel,getLogger
import defusedxml.ElementTree as ET


def execute(context):
    '''
    @summary: the entrance of main method, filter item according to the rules
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    cliRet = ''
    errMsg = ''
    
    logger = getLogger(context)
    #源版本
    curVer=getPdtVer(context)
    #目标版本
    destVer=getDestVer(context)
    #设备型号
    devModel=getDevType(context)
    #升级模式
    upgradeMode=getUpgradeModel(context)
    
    SUB_FILE_PATH = r'packages\UpgradeEvaluation\products\18000V100R001C00\innerVerion\checklist_innerversion_base.xml'
    filePath = os.getcwd() + os.sep + SUB_FILE_PATH.replace('\\', os.sep)
    filterList = ET.parse(filePath)
    
    #根据升级模式过滤
    filterList = filterUpgradeManner(filterList,upgradeMode)
    
    #删除无关属性
    filterList=filterItemName(filterList)
    
    #删除没有孩子节点“item”的“module”节点
    filterNoChildModule(context, filterList)
    
    #node类型转化为str
    cliRet=getCheckList(filterList)
    logger.info('[checklist_filter]check list:' + unicode(cliRet))
    return (flag, cliRet, errMsg)

def getCheckList(node):
    '''
    @Function name      : getCheckList
    @Function describe  : 将节点转化为字符串型checklist
    @Input              : node
    @Return             : checklist
    '''
    root=node.getroot() 
    checklist= ET.tostring(root,encoding="utf-8")
    checklist='''<?xml version="1.0" encoding="UTF-8"?>\n'''+checklist
    return checklist
            
def filterSecureLine(checklist, secure):
    '''
    @Function name      : filterSecureLine(checklist, secure)
    @Function describe  : 根据安全红线过滤checklist
    @Input              : checklist, secure
    @Return             : checklist
    '''
    
    for node in checklist.getiterator("module"):
        items=node.getchildren()
        iFlag=0
        lenItem=len(items)
        while iFlag<lenItem:
            if items[iFlag].attrib.has_key("aftersecure"):
                if items[iFlag].attrib["aftersecure"].lower() != unicode(secure).lower():
                    node.remove(items[iFlag])
                    iFlag-=1
                    lenItem-=1
            iFlag+=1 
    return checklist

def filterUpgradeManner(checklist, method):
    '''
    @Function name      : filterUpgradeManner(checklist)
    @Function describe  : 根据升级方式过滤checklist
    @Input              : checklist, method
    @Return             : checklist
    '''
    for node in checklist.getiterator("module"):
        items=node.getchildren()
        iFlag=0
        lenItem=len(node.getchildren())
        while iFlag<lenItem:
            if items[iFlag].attrib.has_key("upgrademode") and items[iFlag].attrib["upgrademode"].lower()!='all':
                if items[iFlag].attrib["upgrademode"].lower() != method.lower():
                    node.remove(items[iFlag])
                    iFlag-=1
                    lenItem-=1
                iFlag+=1     
            #未配置upgrademode和upgrademode=ALL的情况，默认都为upgrademode=ALL
            else:
                iFlag+=1
    return checklist
    
def filterItemName(checklist):
    '''
    @Function name      : filterItemName(checklist)
    @Function describe  : 输出无关属性
    @Input              : checklist
    @Return             : checklist
    '''
    for node in checklist.getiterator("module"):
        if node is not None:
            del node.attrib["name"]
            for item in node.getchildren():
                del item.attrib["name"]
                if item.attrib.has_key("aftersecure"):
                    del item.attrib["aftersecure"]
                if item.attrib.has_key("upgralimit"):
                    del item.attrib["upgralimit"]
                if item.attrib.has_key("upgrademode"):#兼容upgrademode未配置的情况
                    del item.attrib["upgrademode"]
    return checklist


def filterNoChildModule(context, checklist):
    '''
    @summary: filter the node named 'module' which has no child node
    @param context: the dictionary of data which provided by tool framework
    @param checklist: an object which stand for the XML configuration file is parsed as a tree
    '''
    rootNode = checklist.getroot()
    for nodeModule in rootNode.getchildren():
        curNodeItemList = nodeModule.getchildren()
        #删除空节点
        if not curNodeItemList:
            rootNode.remove(nodeModule)
