# -*- coding: UTF-8 -*-
import traceback
import re
from common import common
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger, getSshObj
       
       
def execute(dataDict):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    log = getLogger(dataDict)
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        errMsg = ""
        cliRet = ""
        cli = getSshObj(dataDict)
        i = 0
        inDeveloper = False

        #老版本要切换到developer下面执行
        if "V100R001C00B033" == common.getCurrentVesion(cli):
            retInfo = common.change2Developer(cli, dataDict)
            cliRet = retInfo[1]
            errMsg = retInfo[2]
            if not retInfo[0]:
                common.anyModel2Cli(cli)
                flag = CheckedResult.NOTPASS
                log.info("Sequence[BBURemainLife] inspect not pass. (can't enter to developer model!)")
                return(flag, cliRet, errMsg)
            inDeveloper = True
        # 小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show bbu life"
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet = common.isCliExecRetInBlackList(cli, cmd, lang, True)
        cliRet4Bbu = checkRet[1]
        cliRet += cliRet4Bbu

        errMsg = checkRet[2]
        if checkRet[0]:
            log.info("Sequence[BBURemainLife] inspect not pass. (system abnormal!)")
            flag = CheckedResult.NOTPASS
            if inDeveloper == True:
                common.anyModel2Cli(cli)
                inDeveloper = False
            return (flag, cliRet, errMsg)
        # 小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End

        # BBU不在位检查通过 modified 20140522 Begin
        if not (re.search("ID", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Remaining Lifetime", cliRet4Bbu, re.IGNORECASE)):
            cliRet4BbuList = cliRet4Bbu.splitlines()
            #BBU不在位
            if re.search("Command executed successfully", cliRet4Bbu, re.IGNORECASE) or len(cliRet4BbuList) <= 3:
                flag = CheckedResult.NOTPASS
                if inDeveloper == True:
                    common.anyModel2Cli(cli)
                    inDeveloper = False
                log.info("Sequence[BBURemainLife] BBU does not exist!")
                if "zh" == lang:
                    errMsg = u"\nBBU不在位。"
                else:
                    errMsg = "\nBBU does not exist."
                return (flag, cliRet, errMsg)
        else:
            #检测BBU个数是否达标
            retTuple = common.checkBbuNum(cli, lang, errMsg, cliRet4Bbu)
            flag = retTuple[0]
            cliRet4SysInfo = retTuple[1]
            cliRet += cliRet4SysInfo
            errMsg = retTuple[2]

            if flag == True:
                flag = CheckedResult.PASS
            else:
                flag = CheckedResult.NOTPASS

            #检测BBU寿命
            cliRet4BbuList = cliRet4Bbu.splitlines()
            for line in cliRet4BbuList:
                i = i + 1
                if i >= 5:
                    list2 = line.split()
                    if len(list2) != 2:
                        continue

                    bbuId = list2[0]
                    bbuRemainingLifetime = list2[1]
                    if "--" == bbuRemainingLifetime:
                        flag = CheckedResult.NOTPASS
                        if "zh" == lang:
                            errMsg += u"\nBBU[" + bbuId + u"]生命剩余时间未能查到。"
                        else:
                            errMsg += "\nThe remain life of BBU[" + bbuId + "] can't be queried."
                        continue

                    if int(bbuRemainingLifetime) < 90:
                        flag = CheckedResult.NOTPASS
                        if "zh" == lang:
                            errMsg += u"\nBBU[" + bbuId + u"]剩余寿命小于90天。"
                        else:
                            errMsg += "\nThe Remaining Lifetime of BBU[" + bbuId + "] is less than 90 days."

            if not flag:
                log.info("Sequence[BBURemainLife] inspect not pass.")

            if inDeveloper == True:
                common.anyModel2Cli(cli)
                inDeveloper = False
            return (flag, cliRet, errMsg)
        # 巡检项检查结果优化 modified End
        # BBU不在位检查通过 modified 20140522 End

    except Exception:
        log.error("Sequence[BBURemainLife] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
    finally:
        if inDeveloper == True:
            try:
                common.anyModel2Cli(cli)
                inDeveloper = False
            except:
                log.error("Sequence[BBURemainLife] catch except of trace back")
