# -*- coding: UTF-8 -*-
import traceback
import re
from common import common
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger, getSshObj
from common import util

def execute(dataDict):
    """
    Create date        : 2012/05/18 
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = ""
        cli = getSshObj(dataDict)
        
        # 小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show bbu general"
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet4Bbu = checkRet[1]
        errMsg = checkRet[2]
        cliRet += cliRet4Bbu
        if checkRet[0]:
            flag = CheckedResult.NOTPASS
            log.info("Sequence[BBUStatus] inspect not pass. (system abnormal!)")
            return (flag, cliRet, errMsg)
        # 小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        # BBU不在位检查通过 modified 20140522 Begin
        #不能查到BBU状态信息
        if not (re.search("ID", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Health", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Running", cliRet4Bbu, re.IGNORECASE)):
            cliRet4BbuList = cliRet4Bbu.splitlines()
            #BBU不在位
            if re.search("Command executed successfully", cliRet4Bbu, re.IGNORECASE) or len(cliRet4BbuList) <= 3:
                flag = CheckedResult.NOTPASS
                log.info("Sequence[BBUStatus] BBU does not exist!")
                if "zh" == lang:
                    errMsg = u"\nBBU不在位。"
                else:
                    errMsg = "\nBBU does not exist."
                return (flag, cliRet, errMsg)
        else:
            #检测BBU个数是否达标
            retTuple = common.checkBbuNum(cli, lang, errMsg, cliRet4Bbu)
            flag = retTuple[0]
            cliRet4SysInfo = retTuple[1]
            errMsg = retTuple[2]
            cliRet += cliRet4SysInfo

            if flag == True:
                flag = CheckedResult.PASS
            else:
                flag = CheckedResult.NOTPASS
                
            #检测BBU状态是否正常
            BbuList = util.formatStr(cliRet4Bbu)
            for i in range(len(BbuList)):
                bbuId = unicode(BbuList[i].get("ID"))
                bbuHealthStatus = unicode(BbuList[i].get("Health Status"))
                bbuRunningStatus = unicode(BbuList[i].get("Running Status"))
                if "Normal" != bbuHealthStatus:
                    flag = CheckedResult.NOTPASS
                    log.info("Sequence[BBUStatus] health status of BBU(" + bbuId + ") is abnormal(" + bbuHealthStatus + ")")
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]健康状态异常(" + bbuHealthStatus + u")。"
                    else:
                        errMsg += "\nThe health status of BBU[" + bbuId + "] is abnormal(" + bbuHealthStatus + ")."
                if bbuRunningStatus.lower() not in  ["online","charging","discharging"]:
                    flag = CheckedResult.NOTPASS
                    log.info("Sequence[BBUStatus] running status of BBU(" + bbuId + ") is abnormal(" + bbuRunningStatus + ")")
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]运行状态异常(" + bbuRunningStatus + u")。"
                    else:
                        errMsg += "\nThe running status of BBU[" + bbuId + "] is abnormal(" + bbuRunningStatus + ")."
        return (flag, cliRet, errMsg)
        # BBU不在位检查通过 modified 20140522 End
        # 巡检项检查结果优化 modified End

    except Exception:
        log.error("Sequence[BBUStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
