# -*- coding: UTF-8 -*-
import traceback
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger
from common import util

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Enclosure Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show enclosure")

        lines = cliRet.splitlines()
        for field in lines:
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[enclosureStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                log.info("There is an error in Sequence[enclosureStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
        enclosureList = util.formatList(cliRet)
        for enclosureInfo in enclosureList:
            enclosureId = enclosureInfo.get("ID")
            logicType = enclosureInfo.get("Logic Type")
            healthStatus = enclosureInfo.get("Health Status")
            runningStatus = enclosureInfo.get("Running Status")
            if logicType != "Data Switch":#不检查交换机
                if healthStatus != "Normal" or runningStatus != "Online":
                    flag = CheckedResult.NOTPASS
                    tuple2BReplaced = (enclosureId, healthStatus, runningStatus)
                    if "zh" == lang:
                        errMsg += u"\n框[%s]状态异常（Health Status：%s，Running Status：%s）。" % tuple2BReplaced
                    else:
                        errMsg += "\nThe status of enclosure[%s] is abnormal(Health Status: %s, Running Status: %s)." % tuple2BReplaced
    
        return (flag, cliRet, errMsg)
    
    except Exception: 
        log.error("Sequence[enclosureStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
