# -*- coding: UTF-8 -*-
import traceback
from common.util import checkCliInfoValid,formatList
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger


# **************************************************************************** #
# 函数名称: checkFcPorts
# 功能说明: 判断FC端口是否巡检通过
# 输入参数: cli
# 输出参数: CheckedResult.PASS or CheckedResult.NOTPASS
# **************************************************************************** # 
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check FC port status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show port general physical_type=FC")
        
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                #包含不存在的情况
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatList(cliRet)
        for dictFCPort in formatedDictList:
            if dictFCPort.get("Health Status") != "Normal":
                flag = CheckedResult.NOTPASS
                tuple2Breplaced = (dictFCPort.get("ID"),dictFCPort.get("Health Status"))
                if "zh" == lang:
                    errMsg += u"\nFC端口[%s]健康状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe health status of FC port [%s] is abnormal(%s)." % tuple2Breplaced 
                continue
            elif dictFCPort.get("Running Status") == "Link Up" or dictFCPort.get("Running Status") == "Running":
                if dictFCPort.get("Working Rate(Mbps)") not in ["2000", "4000", "8000", "16000"]:
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (dictFCPort.get("ID"),dictFCPort.get("Working Rate(Mbps)"))
                    if "zh" == lang:
                        errMsg += u"\nFC端口[%s]速率异常（%s Mbps）。" % tuple2Breplaced
                    else:
                        errMsg += "\nThe speed of FC port[%s] is abnormal(%sMbps)." % tuple2Breplaced
                    continue
            elif dictFCPort.get("Running Status") == "Link Down":
                continue
            else:
                flag = CheckedResult.NOTPASS
                tuple2Breplaced = (dictFCPort.get("ID"),dictFCPort.get("Running Status"))
                if "zh" == lang:
                    errMsg += u"\nFC端口[%s]运行状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe running status of FC port[%s] is abnormal(%s)." % tuple2Breplaced
                continue
                
            
        return (flag, cliRet, errMsg)
        
    except Exception:
        log.error("Sequence[fcPort] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)