# -*- coding: UTF-8 -*-
import traceback
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger
from frame.cli import cliUtil

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check fibre Module Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        cmd_current = "show port fibre_module|filterColumn include columnList=PortID,Health\sStatus"
        cmd = "show port fibre_module|filterColumn include colunmList=PortID,Health\sStatus"
        errMsg = ""
        cliRet = getCliRet(dataDict, cmd)
        if not cliUtil.hasCliExecPrivilege(cliRet):
            cliRet = getCliRet(dataDict,cmd_current)

        lines = cliRet.splitlines()
        i = 0
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[fibreModule] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                log.info("There is an error in Sequence[fibreModule]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if - 1 != field.find(":/>") or field.startswith("developer:/>"):
                    log.info("Sequence[fibreModule] field is:" + unicode(field))
                    continue
                portId = list2[0]
                if list2[1] != "Normal":
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (portId,list2[1])
                    if "zh" == lang:
                        errMsg += u"\n端口[%s]状态异常（%s）。" % tuple2Breplaced 
                    else:
                        errMsg += "\nThe status of port[%s] is abnormal(%s)." % tuple2Breplaced
        return (flag, cliRet, errMsg)
    
    except Exception:
        log.error("Sequence[fibreModule] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)


