# -*- coding: UTF-8 -*-
import traceback
from common import util
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check ISCSI port status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict,"show port general physical_type=ETH logic_type=Host_Port")
        
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                #包含不存在的情况
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatList(cliRet)
        for dictHostPort in formatedDictList:
            if dictHostPort.get("Health Status") != "Normal":
                flag = CheckedResult.NOTPASS
                tuple2Breplaced = (dictHostPort.get("ID"), dictHostPort.get("Health Status"))
                if "zh" == lang:
                    errMsg += u"\niSCSI端口[%s]健康状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe health status of iSCSI port [%s] is abnormal(%s)." % tuple2Breplaced
                continue
            elif dictHostPort.get("Running Status") == "Link Up" or dictHostPort.get("Running Status") == "Running":
                if dictHostPort.get("Working Rate(Mbps)") not in ["10", "100", "1000", "10000"]:
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (dictHostPort.get("ID"), dictHostPort.get("Working Rate(Mbps)"))
                    if "zh" == lang:
                        errMsg += u"\niSCSI端口[%s]速率异常（%s Mbps）。" % tuple2Breplaced
                    else:
                        errMsg += "\nThe speed of iSCSI port[%s] is abnormal(%s Mbps)." % tuple2Breplaced
                    continue
            elif dictHostPort.get("Running Status") == "Link Down":
                continue
            else:
                flag = CheckedResult.NOTPASS
                tuple2Breplaced = (dictHostPort.get("ID"), dictHostPort.get("Running Status"))
                if "zh" == lang:
                    errMsg += u"\niSCSI端口[%s]运行状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe running status of iSCSI port[%s] is abnormal(%s)." % tuple2Breplaced
                continue
            
        return (flag, cliRet, errMsg)
        
    except Exception:
        log.error("Sequence[iscsiPort] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
