# -*- coding: UTF-8 -*-
import traceback
from common.util import checkCliInfoValid,formatList
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check PCIE switch status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show enclosure")
        if not util.checkCliInfoValid(cliRet, True):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return (flag, cliRet, errMsg)
        
        ctrlEncCount = 0
        existDataSwich = False
        enclosureList = util.formatList(cliRet)
        for enclosureInfo in enclosureList:
            enclosureID = enclosureInfo.get("ID")
            logicType = enclosureInfo.get("Logic Type")
            healthStatus = enclosureInfo.get("Health Status")
            runningStatus = enclosureInfo.get("Running Status")
            
            if logicType == "Engine":
                ctrlEncCount += 1
            elif logicType == "Data Switch":
                existDataSwich = True
                if healthStatus != "Normal" or runningStatus != "Online":
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (enclosureID, healthStatus, runningStatus)
                    if "zh" == lang:
                        errMsg += u"\nPCIe交换机[%s]状态异常（Health Status：%s，Running Status：%s）。" % tuple2Breplaced
                    else:
                        errMsg += "\nThe status of PCIe switch[%s] is abnormal(Health Status: %s, Running Status: %s)." % tuple2Breplaced
            else:
                pass
            
        if ctrlEncCount != 1 and not existDataSwich:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n未查询到PCIe交换机。" 
            else:
                errMsg += u"The PCIe switch being queried does not exist."

        return (flag, cliRet, errMsg)

    except Exception: 
        log.error("Sequence[pcieSwitchStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
