# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

import traceback

def execute(context):
    '''
    1、只有满足以下条件的版本才需要进行该检查，否则检查结果为通过。
1.1 设备型号为18000 V1系列设备，且升级的目标版本小于V1R1C30SPC300
1.2 设备型号为T系列设备，且升级的目标版本小于V200R002C30SPC300
1.3 设备型号为V3系列设备，且升级的目标版本小于V300R002C10SPC200
2、步骤2命令中没有查到端口信息，或命令回显中"Running Status"字段值都为“Link Down”，检查通过。其他情况，检查不通过。

    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""
    checkFlag = False
    idList = []
    try:
        #当前设备版本
        curDeviceVersion = contextUtil.getCurVersion(context)
        #目标版本
        tagerVersion = contextUtil.getTargetVersion(context)
        #当前设备型号
        deviceType = contextUtil.getDevType(context)
        logger.logInfo("tagerVersion is :%s,deviceType is :%s.,curDeviceVersion is :%s" % (tagerVersion,deviceType,curDeviceVersion))

        if "V1" in curDeviceVersion and "18" in deviceType and tagerVersion < "V100R001C30SPC300":
            checkFlag = True
        if 'T' in deviceType and tagerVersion < "V200R002C30SPC300":
            checkFlag = True
        if 'V3' in deviceType and "Dorado" not in deviceType and tagerVersion < "V300R002C10SPC200":
            checkFlag = True


        logger.logInfo("checkFlag is: %s" % checkFlag)
        if not checkFlag:
            return common.getUpgEvaluationRs(True, cliRet, errMsg)

        cmd = "show port general physical_type=FCoE"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        #出现^结果为不涉及
        if not cliUtil.hasCliExecPrivilege(cliRet):
            logger.logInfo("cliRet have ^ or not have privilege.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, "")
        #通过
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, "")
        #下发命令失败，未检查
        if not checkRet[0]:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)

        successFlag = True
        for retDict in cliRetLinesList:
            runningStatus = retDict.get("Running Status","")
            if runningStatus.lower() != "link down":
                successFlag = False
                id = retDict["ID"]
                idList.append(id)

        if not successFlag:
            errMsg = common.getMsg(lang, "portFCoE.notpass", ",".join(idList))
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        return common.getUpgEvaluationRs(True, cliRet, errMsg)
    except:
        logger.logInfo("exception=[%s]" % str(traceback.format_exc()))
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
