# -*- coding: UTF-8 -*-
import traceback
from common.util import checkCliInfoValid, formatStr
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check clone general status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        cliRet = getCliRet(dataDict, "show clone general")
        
        # 中文回显  modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedDictList = formatStr(cliRet)
        for i in range(len(formatedDictList)):
            cloneID = unicode(formatedDictList[i].get("Clone ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                tuple2Breplaced = (cloneID, healthStatus)
                log.info("Sequence[cloneHealthStatus] inspect clone general, ID:%s, healthStatus:%s" % tuple2Breplaced)
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n克隆[%s]状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe status of clone[%s] is abnormal(%s)." % tuple2Breplaced
        # 中文回显  modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except Exception:
        log.error("Sequence[cloneHealthStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)