# -*- coding: UTF-8 -*-
import traceback
import os
import re

from frame.common import common
from frame.common.regex import RegPattern
from frame.cli import cliUtil
from frame.context import contextUtil


def execute(context):
    '''
    @summary: the entrance of main method, this check item is used to check IO status
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (integer, string, string)
    '''
    flag = True
    cliRet = ''
    errMsg = ''
    lang = contextUtil.getLang(context)
    log = common.getLogger(contextUtil.getLogger(context), __file__)
    try:
        #步骤1：获取所有控制器IP和ID
        ctrlIpAndIdMapList = contextUtil.getCtrlIpAndIdMap(context)
        if not ctrlIpAndIdMapList:
            log.logInfo(common.getMsg(lang, 'cannot.ctrl.id.ip'))
            return common.getUpgEvaluationRs(cliUtil.RESULT_WARNING, cliRet, common.getMsg(lang, 'cannot.ctrl.id.ip'))
        
        #步骤2：对每个控制器都执行检查
        for contrlInfo in ctrlIpAndIdMapList:
            ctrlId = contrlInfo[0]
            ctrlIpv4 = contrlInfo[1]
            ctrlIpv6 = contrlInfo[2]
            checkRet = checkEachCtrlIoStatus(context, (ctrlIpv4,ctrlIpv6), ctrlId)
            if checkRet[1]:
                checkRetTmp = "[Controller %s's details]:" % ctrlId
                cliRet += checkRetTmp + '\n' + checkRet[1].strip() + '\n\n'
            if checkRet[0] is True:#通过
                midMsg = common.getMsg(lang, 'controller.check.pass')
                errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
                continue
            errMsg += common.getMsg(lang, 'title.controller', ctrlId) + checkRet[2] + os.linesep
            if checkRet[0] is False:#不通过
                flag = False
                continue
            if flag is not False:#其它检查结果，如警告
                flag = checkRet[0]
        return common.getUpgEvaluationRs(flag, cliRet.strip(), errMsg)
    except Exception, exception: 
        log.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet.strip(), common.getMsg(lang, 'query.result.abnormal'))


def checkEachCtrlIoStatus(context, ctrlIps, ctrlId):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ''
    errMsg = ''
    logger.logInfo('start checking controller[%s]' % ctrlId)
    
    curCtrlIp = contextUtil.getCurCtrlIp(context)
    ctrlIp = ''
    if re.match(RegPattern.IPV4, curCtrlIp):#IPV4
        ctrlIp = ctrlIps[0]
    else:#IPV6
        ctrlIp = ctrlIps[1]
    
    if curCtrlIp == ctrlIp:#当前控制器直接获取
        cli = contextUtil.getSSH(context)
    else:#新建cli连接
        #先使用ipv4创建，如果失败再用ipv6创建
        cli = contextUtil.createCliConnection(context, ctrlIps[0])
        if cli is None:
            cli = contextUtil.createCliConnection(context, ctrlIps[1])
    
    if cli == None:
        logger.logInfo('create controller [%s] cli connection failed' % ctrlId)
        errMsg = common.getMsg(lang, 'cannot.create.controller.cli')
        return (cliUtil.RESULT_WARNING, '', errMsg)
    
    try:
        #查询透写等待IO数目：为0个或没有表示检查通过
        cmd = 'writehole showlist'
        flag, cliRet, errMsg = cliUtil.executeCmdInDebugMode(context, cmd, True, cli)
        if flag != True:
            logger.logSysAbnormal()
            return (flag, cliRet, errMsg)
        keyword = 'writehole wait io num'
        if re.search(keyword, cliRet, re.IGNORECASE):
            writeholeWaitIoNum = getWriteholeWaitIoNum(cliRet, keyword)
            if '0' != writeholeWaitIoNum:
                errMsg = common.getMsg(lang, 'check.io.status.notpass')
                return (False, cliRet, errMsg)
        return (True, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
        if curCtrlIp != ctrlIp:
            cliUtil.closeCliConnection(cli)


def getWriteholeWaitIoNum(cliRet, keyword):
    '''
    @summary: get the number of writehole wait IO
    @param cliRet: the CLI information of command 'writehole showlist'
    @param keyword: the keyword which need to look for
    @return: the number of writehole wait IO as string
    '''
    tmpNum = ''
    lineList = cliRet.splitlines()
    for line in lineList:
        if keyword in line:
            tmpNum = line.split(':')[-1]
            break
    return tmpNum.strip()

