# -*- coding: UTF-8 -*-
import traceback
import re 
from common.cmdRetManager import getCliRet
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check remote replication status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show remote_replication general")
        
        lines = cliRet.splitlines()
        i = 0
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[RemoteReplicationStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            # add 20140220 begin
            if re.search("license", field, re.IGNORECASE):
                continue
            # add 20140220 end
            #  远程复制状态判断错误  20131109 Begin
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                log.info("There is an error in Sequence[RemoteReplicationStatus]!")
                # 巡检结果正常显示不正确 20131219 modified Begin
                if "zh" == lang:
                    errMsg = u"\n获取远程复制状态信息出错。"
                else:
                    errMsg = "\nThere is an error in getting remote replication status information."
                return (flag, cliRet, errMsg)
                # 巡检结果正常显示不正确 20131219 modified End
            # 巡检优化 modified 2013-12-10 begin
            i = i + 1
            if i > 4:
                list1 = field.split()
                if -1 != list1[0].find(":/>"):
                    break
                if (len(list1) >= 5) and ("Normal" != list1[1]):
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (list1[0], list1[1])
                    if "zh" == lang:
                        errMsg += u"\n远程复制[%s]状态异常（%s）。" % tuple2Breplaced
                    else:
                        errMsg += "\nThe status of remote replication[%s] is abnormal(%s)." % tuple2Breplaced
        #  远程复制状态判断错误  20131109 End
        return (flag, cliRet, errMsg)
        # 巡检优化 modified 2013-12-10 end
         
    except Exception:
        log.error("Sequence[RemoteReplicationStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
