# -*- coding: UTF-8 -*-
import traceback
from common.util import checkCliInfoValid, formatStr
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check snapshot general status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        cliRet = getCliRet(dataDict, "show snapshot general")

        # 中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedDictList = formatStr(cliRet)
        for i in range(len(formatedDictList)):
            snapID = unicode(formatedDictList[i].get("ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                tuple2Breplaced = (snapID, healthStatus)
                log.info("Sequence[virtualSnapshotHealthStatus] inspect snapshot general, healthStatus:" + healthStatus + ", ID: " + snapID)
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n快照[%s]状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe status of snapshot[%s] is abnormal(%s)." % tuple2Breplaced
        # 中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except Exception:
        log.error("Sequence[virtualSnapshotHealthStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
