# -*- coding: UTF-8 -*-
import traceback
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger,getPdtVer
from common import util

def execute(context):
    '''
        Disk enclosure number check
        Check whether the number of DAE0xx enclosures exceeds 20. 
        Do the same to DAE1xx enclosures, and so forth. 
    '''
    flag = CheckedResult.PASS
    lang = getLang(context)
    logger = getLogger(context)
        
    cliRet = ""
    errMsg = ""
    MAX_ENCLOSURE_NUM = 20
    DEV_VER_BLACK_LIST = ["V200R002C00SPC100",
                          "V200R002C00SPC200",
                          "V200R002C00SPC300",
                          "V200R002C00SPC400",
                          "V100R001C00SPC100",
                          "V100R001C00SPC200",
                          "V100R001C00SPC300",]
    try:
        
        devVersion = getPdtVer(context)
        logger.info("[check_cli_software_enclosure_number]device version is %s" %devVersion)
        if devVersion not in DEV_VER_BLACK_LIST:
            return (CheckedResult.NOSUPPORT, cliRet, errMsg) 
        
        
        cliRet = getCliRet(context, "show enclosure")
        if not util.checkCliInfoValid(cliRet, False):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return (CheckedResult.NOTPASS, cliRet, errMsg)
        
        cliRetLinesList = util.formatList(cliRet)
        if len(cliRetLinesList) == 0:
            if lang == "zh":
                errMsg = u"\n无法获取硬盘框信息。"
            else:
                errMsg = "\nFailed to obtain information about disk enclosures."
            logger.logNoPass("[check_cli_software_enclosure_number]Cannot get information about enclusure")
            return (CheckedResult.NOTPASS, cliRet, errMsg)
        
        encIdDict = {}
        abnormalLoops = set()
        for line in cliRetLinesList:
            encId = line["ID"]
            
            #if not disk enclosure, continue
            if "DAE" not in encId:
                continue
            
            encPrefix = encId[:4]
            hisEncCount = encIdDict.get(encPrefix,0)
            encIdDict[encPrefix] = hisEncCount + 1
            if encIdDict[encPrefix] > MAX_ENCLOSURE_NUM:
                flag = CheckedResult.NOTPASS
                abnormalLoops.add(encPrefix)
            
        if flag == CheckedResult.NOTPASS:
            abnormalLoops = sorted(abnormalLoops)
            for enc in abnormalLoops:
                if lang == "zh":
                    errMsg += u"%sxx的框数量超过20个，实际框数量为%s个。\n" %(enc, encIdDict[enc])
                else:
                    errMsg += "The number of %sxx enclosures exceeds 20. The current number is %s.\n"%(enc, encIdDict[enc])
            
            return (flag, cliRet, errMsg)
            
        return (flag, cliRet, errMsg)
                                  
    except Exception:
        logger.error("Sequence[enclosure number] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

