 #-*- coding: UTF-8 -*-
import traceback
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger, getDevType, getPdtVer
from common.util import checkCliInfoValid

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check system hot patch
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = ""
        #当前系统版本
        curVersion = ""
        #当前热补丁版本
        curHotVersion = ""
        curHotVersionList = []
        
        #系统版本和需要安装的热补丁
        versionMap = {
                      "V100R001C00" : "V100R001C00SPH002", 
                      "V100R001C00SPC100" : "V100R001C00SPH101"
                      }
        
        #获取当前系统版本
        curVersion = getPdtVer(dataDict)
        cliRet = getCliRet(dataDict, "show upgrade package")
        #当前系统版本没在目标版本内
        if curVersion not in versionMap.keys():
            return (flag, cliRet, errMsg)

        verRetList = cliRet.splitlines()
        #判断回显有效性
        if not checkCliInfoValid(cliRet, False):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return (flag, cliRet, errMsg)
        
        #获取设备当前热补丁版本列表
        for i in range(len(verRetList)):
            if "HotPatch Version" in verRetList[i]:
                newVerRetList = verRetList[i:]
                
        for j in range(len(newVerRetList)):
            if "Controller" in newVerRetList[j]:
                curHotVersionList.append(newVerRetList[j].split()[-3].strip())
        
        #判断控制器之间热补丁版本是否一致
        if len(set(curHotVersionList)) != 1:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n控制器之间热补丁版本不一致。"
            else:
                errMsg += "\nThe hot patch versions of controllers are inconsistent."
            return (flag, cliRet, errMsg)
        
        #获取设备当前热补丁版本
        curHotVersion = curHotVersionList[0]
        log.info("curHotVersion is:" + curHotVersion)
        
        #当前热补丁版本小于目标热补丁版本
        if curHotVersion < versionMap.get(curVersion):
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n设备未安装指定的热补丁。"
            else:
                errMsg += "\nThe specified hot patch has not been installed on the device."
        return (flag, cliRet, errMsg)
    except Exception:
        log.error("[hotPatch] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

