# -*- coding: UTF-8 -*-
import traceback
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger
from common import util



def execute(dataDict):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        allRet = ""
        #Optimize check rate, use filter
        filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        allRet = getCliRet(dataDict, "show lun general ", False)
        cliRet = getCliRet(dataDict, "show lun general " + filterCmd)
        allRet += cliRet

        
        lines = cliRet.splitlines()
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[LUNStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, allRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag =  CheckedResult.NOTPASS
                log.info("There is an error in Sequence[LUNStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, allRet, errMsg)
            
        lunList = util.formatList(cliRet)
        for lunDetail in lunList:
            lunID = lunDetail.get("ID")
            healthStatus = lunDetail.get("Health Status")
            runningStatus = lunDetail.get("Running Status")
            if healthStatus != "Normal" or runningStatus != "Online":
                flag = CheckedResult.NOTPASS
                tuple2Breplaced = (lunID, healthStatus, runningStatus)
                if "zh" == lang:
                    errMsg += u"\nLUN[%s]状态异常（Health Status：%s，Running Status：%s）。" % tuple2Breplaced
                else:
                    errMsg += u"\nThe status of LUN[%s] is abnormal(Health Status: %s, Running Status: %s)." % tuple2Breplaced
            
        return (flag, allRet, errMsg)
    
    except Exception:
        log.error("Sequence[LUNStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag =  CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = u"\nQuery result is abnormal."
        return (flag, allRet, errMsg)
