# -*- coding: UTF-8 -*-
import traceback
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger
from common.util import checkCliInfoValid, formatList
from common.constant import CheckedResult


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check pool status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show storage_pool general")
        
        # 中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)

        listNormalRunning = ["online", "balancing"]
        formatedDictList = formatList(cliRet)
        for i in range(len(formatedDictList)):
            poolID = unicode(formatedDictList[i].get("ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            runningStatus = unicode(formatedDictList[i].get("Running Status"))
            # modified 20140327 begin
            if ("normal" != healthStatus.lower() or runningStatus.lower() not in listNormalRunning):
                log.info("Sequence[PoolStatus] inspect pool, health status:%s, running status:%s" % (healthStatus, runningStatus))
                flag = CheckedResult.NOTPASS
                tuple2Breplaced  = (poolID, healthStatus, runningStatus)
                if "zh" == lang:
                    errMsg += u"\nPool[%s]状态异常（Health Status：%s，Running Status：%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe status of pool[%s] is abnormal(Health Status: %s, Running Status: %s)." % tuple2Breplaced
            # modified 20140327 end
        # 中文回显 modify 20140623 end
        
        return(flag, cliRet, errMsg)
    except Exception:
        log.error("Sequence[PoolStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
