# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 检查BBU电量是否充足
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = "Note: The following information is only for manual check, and it does not affect the final evaluation result.\n\n"
    try:
        
        tlv = contextUtil.getTlvObj(context)
        flag = True
        errMsg = ""
        checkItem = "CHECK_HARDWARE_BBUPOWER"
        logger.logExecCmd(checkItem)
        #根据检查项获取配置字典值
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #保存错误信息的列表
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "query.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
            
        if flag == False:
            cliRet += "BBU backup alarm : 1"
        else:
            cliRet += "BBU backup alarm : 0"
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    