# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

#当前检查项告警ID
alarmId = '0xF0CF0003'

def execute(context):
    '''
    @summary: 控制器故障检查
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    errMsg = ""
    try:
        cmd = "show alarm |filterRow column=ID predict=equal_to value=%s" % alarmId
        LOGGER.logExecCmd(cmd)
        cli = contextUtil.getSSH(context)
        LOGGER.logInfo("[SingleLinknclosure] alarmID:%s" % alarmId)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True,LANG)
        if checkRet[0] != True:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        #判断回显是否有Command executed successfully
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.alarm.info")
            LOGGER.logNoPass("Cannot get information about alarm")
        else:
            errMsg = common.getMsg(LANG, "ControllerBreakdownCheck.notpass")
        return common.getUpgEvaluationRs(False, cliRet, errMsg)
            
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
