# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 检查控制器版本是否一致
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRetValue = "Note: The following information is only for manual check, and it does not affect the final evaluation result.\n\n"
    
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SOFTWARE_VERSIONCONSISTANCE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli回显，不管回显是啥都将其返回到原始信息
        cli = contextUtil.getSSH(context)
        cmd = "show upgrade package"
        cliRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRetValue += cliRet[1]
        
        versionList = []
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            versionList.append(result)
        #返回版本号都相同时返回"True",如果存在TimeOut则返回"TimeOut",否则返回"False"
        itemKey = common.isAllSameItem(versionList)
        #根据itemKey获取对应的字典值,如果失败返回None
        itemVal = itemDict.get(itemKey, None)
        if itemVal is None:
            return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
        status = itemVal.get("status", None)
        if status is False:
            flag = False
            errMsg = common.getMsg(lang, itemVal["msg"])
        return common.getUpgEvaluationRs(flag, cliRetValue, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetValue, common.getMsg(lang, "query.result.abnormal"))