# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        鐢垫簮鐘舵�妫�煡锛�
        Health Status涓篘ormal涓擱unning Status涓篛nline琛ㄧず姝ｅ父锛屽叾瀹冩儏鍐靛潎灞炰簬涓嶆甯哥姸鎬併�
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show power_supply"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.power.supply.info")
            LOGGER.logNoPass("Cannot get information about power supply")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for line in cliRetLinesList:
            power_id = line["ID"]
            healthStatus = line["Health Status"]
            runningStatus = line["Running Status"]
            
            if healthStatus != common.STATUS_NORMAL and runningStatus == common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.health.status.abnormal", (power_id, healthStatus))
                LOGGER.logNoPass("The Health Status of power supply [%s] is abnormal (Health Status:%s)" % 
                    (power_id, healthStatus))
            elif healthStatus == common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.running.status.abnormal", (power_id, runningStatus))
                LOGGER.logNoPass("The Running Status of power supply [%s] is abnormal (Running Status:%s)" % 
                    (power_id, runningStatus))
            elif healthStatus != common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.status.abnormal", (power_id, healthStatus, runningStatus))
                LOGGER.logNoPass("The Status of power supply [%s] is abnormal (Health Status:%s,Running Status:%s)" % 
                    (power_id, healthStatus, runningStatus))
            else:
                continue
        if flag:
            LOGGER.logPass()
                
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
