# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    @summary: DiskDomain故障检查
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    flag = True
    cliRet = ""
    errMsg = ""
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        LOGGER.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    try:
        cli = contextUtil.getSSH(context)
        alarmList = ["0x10A008","0xF00A001","0x10A001"]
        for alarmKey in alarmList:
            cmd = 'show alarm |filterRow column=ID predict=equal_to value=%s' % alarmKey
            LOGGER.logExecCmd(alarmKey)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            if checkRet[0] != True:
                errMsg = common.getMsg(LANG, "query.result.abnormal")
                LOGGER.logSysAbnormal()                
            cliRet += checkRet[1] + "\n"
            #判断回显是否有Command executed successfully
            if cliUtil.queryResultWithNoRecord(cliRet):
                continue
            cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
            flag = False
            if len(cliRetLinesList) == 0:
                errMsg = common.getMsg(LANG, "cannot.get.alarm.info")
                LOGGER.logNoPass("Cannot get information about alarm")
            else:
                errMsg = common.getMsg(LANG, "check.diskDomainFaultStatus.notpass",alarmKey)
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)            
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
