# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

PAGE_NUMBER_LOWER_LIMIT = 65536
CHUNK_NUMBER_LOWER_LIMIT = 12288

LimitedCurVersion = ['V300R001C00', 'V200R002C10', 'V100R001C10']

def execute(context):
    '''
    @summary: 硬盘域保有量检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        CurVersion = contextUtil.getCurVersion(context)
        logger.logInfo("CurVersion:%s" % CurVersion)
        #不在源版本内不存在此问题,则检查通过
        if str(CurVersion) not in LimitedCurVersion:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        cmd = 'show disk_domain general'
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang, contextUtil.getDeveloperPwd(context))
        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            flag = False
            errMsg = common.getMsg(lang, "query.result.abnormal")
        else:
            diskDomainIdList = [item["ID"] for item in cliRetLinesList]
            for domainId in diskDomainIdList:
                checkRet = checkDiskDomainPossessionForId(cli, logger, lang, domainId)
                if not checkRet[0]:
                    logger.logInfo('Check disk domain possession no pass!!')
                    return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

def checkDiskDomainPossessionForId(cli, logger, lang, domainId):
    cmd = 'show disk_domain_possessed general disk_domain_id=%s' % domainId
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        logger.logSysAbnormal()
        return checkRet
    #判断回显是否有Command executed successfully
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        errMsg = common.getMsg(lang, "DiskDomainPossessionCheck.pass")
        return (True, cliRet, errMsg)
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return (True, cliRet, errMsg)
   
    for checkRetDict in cliRetLinesList:
        pageNumber = checkRetDict.get('Page Number')
        chunkNumber = checkRetDict.get('Chunk Number')
        if int(pageNumber) < PAGE_NUMBER_LOWER_LIMIT or int(chunkNumber) < CHUNK_NUMBER_LOWER_LIMIT:
            logger.logInfo('Check disk domain possession no pass, disk domain id is [%s], page number is [%s], chunk number is [%s] '%(domainId, pageNumber, chunkNumber))
            errMsg = common.getMsg(lang, "DiskDomainPossessionCheck.notpass")
            return (False, cliRet, errMsg)
    errMsg = common.getMsg(lang, "DiskDomainPossessionCheck.pass")
    return (True,cliRet, errMsg)
