# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
                      远端设备链路状态检查：
        1 如果远端设备链路不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show remote_device link"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        linkNameList = ["FC", "ISCSI"]
        for linkName in linkNameList:
            linkRet = cliUtil.getSplitedCliRet(cliRet, linkName + " Link:")
            if len(linkRet) == 0:
                continue
            
            cliRetLinesList = cliUtil.getHorizontalCliRet(linkRet)
            if len(cliRetLinesList) == 0:
                flag = False
                errMsg += common.getMsg(lang, "cannot.get.link.info", linkName)
                logger.logNoPass("Cannot get information about %s Link" % linkName)
                continue
            
            for line in cliRetLinesList:
                Id = line["ID"]
                healthStatus = line["Health Status"]
                if healthStatus != common.STATUS_NORMAL:
                    flag = False
                    errMsg += common.getMsg(lang, "remote.device.link", (linkName, Id, healthStatus))
                    logger.logNoPass("The Health Status of remote device link [%s] in %s link is abnormal (Health Status:%s)" % 
                            (Id, linkName, healthStatus))
        
        if flag:
            logger.logPass()  
        
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    