# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
      KVDB实例资源检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""

    try:
        cmd = "cmm show prlist mid 350"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang)
        cliRet = checkRet[1]

        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, checkRet[2])

        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])

        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)

        if len(cliRetLinesList) == 0:
            logger.logNoPass("Cannot get information about snapshot")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

        resultCliRet = {}
        for line in cliRetLinesList:
            if line.get("PartName") == "ddp!domain!object":
                resultCliRet["UsedCnt"] = line.get("UsedCnt")
                continue
            elif line.get("PartName") == "ddp!table!instance":
                resultCliRet["MaxCnt"] = line.get("MaxCnt")
                continue
            elif "ddp domain" in line.get("PartitionName", ''):
                resultCliRet["UsedCnt"] = line.get("UsedCnt")
                continue
            elif "ddp table" in line.get("PartitionName", ''):
                resultCliRet["MaxCnt"] = line.get("TotalCnt")
                continue

            if "UsedCnt" in resultCliRet and "MaxCnt" in resultCliRet:
                logger.logNoPass("UsedCnt is %s, MaxCnt is %s" % (str(resultCliRet['UsedCnt']),
                                                                  str(resultCliRet['MaxCnt'])))
                break
        if "UsedCnt" not in resultCliRet or "MaxCnt" not in resultCliRet:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

        if int(resultCliRet["UsedCnt"]) * 4 > int(resultCliRet["MaxCnt"]):
            return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "KVDB.check.fail"))

        return common.getUpgEvaluationRs(True, cliRet, "")

    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
