# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

SUPPORT_VERSION_LIST = ["V300R003C20SPC100","V300R006C00"]

def execute(context):
    '''
        DNS服务器探测配置检查:
        步骤1执行如下命令：show dns_server general，获取当前配置DNS Server探测配置列表 IP Address List的地址个数 。
        判断标准：
        1.检查check switch字段的值，如果值为Off则检查通过，如果没有check switch字段也检查通过。
        2.检查DNSserver的个数是否大于1，如果大于1则检查不通过。如果小于等于1，则检查通过。


    '''

    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    errMsg = ""
    allCliRet = ""
    cli = contextUtil.getCLI(context)
    curDeviceVersion = contextUtil.getCurVersion(context)

    #该检查项只检查V300R003C20SPC100","V300R006C00 2个版本
    if curDeviceVersion not in SUPPORT_VERSION_LIST :
        logger.logInfo("current Device Version = %s" % curDeviceVersion)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, allCliRet, errMsg)


    try:
        #获取回显中"IP Address List"的IP数量
        cmd = "show dns_server general"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        allCliRet += cliRet

        #判断是否含异常场景
        if flag != True:
            logger.logInfo('execute ger dns server cmd is error.')
            errMsg = common.getMsg(lang, "cannot.get.dns.server.disposelist")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        #检查IP地址个数
        flag, errMsg = checkDnsServerIp(cliRet, lang, logger)
        if flag != True:
            logger.logInfo("error")
            return common.getUpgEvaluationRs(flag, allCliRet, errMsg)

        return common.getUpgEvaluationRs(flag, allCliRet, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(lang, "query.result.abnormal"))


def checkDnsServerIp(cliRet, lang, logger):
    '''
    @summary: 提取出IP列表中地址数量
    @param cliRet: 收集到的信息回显
    @return: flag , errMsg
    '''

    IPADD_LIST = 'IP Address List'
    SWITCH_STATUS ='Check Switch'
    ipAddressStr = ''
    checkSwitch = ''
    errMsg = ''

    dnsServerCliRet = cliUtil.getVerticalCliRet(cliRet)
    #查看是否回显未取到值
    if len(dnsServerCliRet) == 0:
        errMsg = common.getMsg(lang, "cannot.get.dns.server.disposelist")
        logger.logInfo("Cannot get dns server disposelist")
        return (cliUtil.RESULT_NOCHECK, errMsg)

    try:
        if SWITCH_STATUS not in dnsServerCliRet[0]:
            logger.logInfo("not have check switch")
            return (True, "")

        checkSwitch = dnsServerCliRet[0].get(SWITCH_STATUS)
        if checkSwitch == "Off":
            return (True, "")

        ipAddressStr = dnsServerCliRet[0].get(IPADD_LIST)
        #如果存在关键字
        if ipAddressStr is not None:
            ipList = ipAddressStr.split()
            if len(ipList) > 1:
                logger.logInfo("ipList : %s" % len(ipList))
                errMsg = common.getMsg(lang, "dns.server.disposelist.overstep", len(ipList))
                return (False, errMsg)
            else:
                return (True, "")
        else:
        #没有关键字的情况下
            errMsg = common.getMsg(lang, "cannot.get.dns.server.disposelist")
            logger.logInfo("IP Address List is not being.")
            return (False, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return (cliUtil.RESULT_NOCHECK, common.getMsg(lang, "query.result.abnormal"))


