# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil


def execute(context):
    '''
    1、待升级到的目标版本为V300R003C10或V300R003C10SPC100。
    2、升级到的目标版本为V300R003C10或V300R003C10SPC100，并且show service ndmp中的“Is Enabled”字段为“NO”则检查项通过。如果为“YES”则需要继续执行3。
    3、若show license中存在Feature Name 字段为HyperSnap的回显，则检查通过，否则不通过。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRetAll = ""
    errMsg = ""
    sourceVersionList = ['V300R002C00','V300R002C00SPC100','V300R002C10','V300R002C10SPC100','V300R002C10SPC200','V300R003C00','V300R003C00SPC100']
    targetVersionList = ['V300R003C10','V300R003C10SPC100']
    devModelList = ['5300 V3','5500 V3','5600 V3','5800 V3','6800 V3','18500 V3','18800 V3']

    try:
        curentVersion = common.formatVersion(contextUtil.getCurVersion(context))
        targetVersion = common.formatVersion(contextUtil.getTargetVersion(context))
        devModel = contextUtil.getDevType(context)
        LOGGER.logInfo("curentVersion: %s, targetVersion: %s, devModel:%s " % (curentVersion, targetVersion, devModel))
        
        if curentVersion not in sourceVersionList or targetVersion not in targetVersionList or devModel not in devModelList:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg)
            
        #普通用户模式执行show service ndmp
        cmd = "show service ndmp"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += checkRet[1]
        
        if checkRet[0] != True: 
            errMsg += checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
        
        #“Is Enabled”字段为“NO”则检查项通过
        cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
        isNdmpUsed = cliRetLinesList[0].get("Is Enabled")
        if isNdmpUsed.upper() == 'No'.upper():
            return common.getUpgEvaluationRs(True, cliRetAll, errMsg)
 
        #普通用户模式执行show license
        cmd = "show license"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += "\n\n%s" % checkRet[1]
        
        #ndmp服务能够使用，一定有license存在
        if checkRet[0] != True:
            errMsg += checkRet[2] 
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg) 
        
        #Feature Name字段存在为HyperSnap的回显，则检查通过
        cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
        for cliRetLines in cliRetLinesList:
            featureName = cliRetLines.get("Feature Name")
            if featureName.upper() == 'HyperSnap'.upper():
                return common.getUpgEvaluationRs(True, cliRetAll, "")

        errMsg += common.getMsg(LANG, "check.ndmpAndSnapshotLicense.notpass")
        LOGGER.logNoPass("NDMP is used but snapshot license is unavailable.")        
        return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
        
    except Exception, exception: 
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, 'query.result.abnormal'))

